/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractModuleNode
extends ProjectViewNode<Module>
implements NavigatableWithText {
    protected AbstractModuleNode(Project project, Module module2, ViewSettings viewSettings) {
        super(project, (Object)module2, viewSettings);
    }

    public void update(PresentationData presentation) {
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            this.setValue(null);
            return;
        }
        presentation.setPresentableText(module2.getName());
        if (this.showModuleNameInBold()) {
            presentation.addText(module2.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        presentation.setIcon(ModuleType.get((Module)module2).getIcon());
        presentation.setTooltip(ModuleType.get((Module)module2).getName());
    }

    protected boolean showModuleNameInBold() {
        return true;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        Module module2 = (Module)this.getValue();
        List<VirtualFile> list2 = module2 != null ? Arrays.asList(ModuleRootManager.getInstance((Module)module2).getContentRoots()) : Collections.emptyList();
        if (list2 == null) {
            AbstractModuleNode.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        Module module2;
        if (file2 == null) {
            AbstractModuleNode.$$$reportNull$$$0(1);
        }
        if ((module2 = (Module)this.getValue()) == null || module2.isDisposed()) {
            return false;
        }
        if (file2.getFileSystem() instanceof JarFileSystem) {
            VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(file2);
            if (local == null) {
                return false;
            }
            file2 = local;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void navigate(boolean requestFocus) {
        Module module2 = (Module)this.getValue();
        if (module2 != null) {
            ProjectSettingsService.getInstance(this.myProject).openModuleSettings(module2);
        }
    }

    public String getNavigateActionText(boolean focusEditor) {
        return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
    }

    public boolean canNavigate() {
        return ProjectSettingsService.getInstance(this.myProject).canOpenModuleSettings() && this.getValue() != null;
    }

    public String getTestPresentation() {
        return "Module";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/AbstractModuleNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/AbstractModuleNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

