/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SynchronizeCurrentFileAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        List files = SynchronizeCurrentFileAction.getFiles(e).take(2).toList();
        if (e.getProject() == null || files.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText(SynchronizeCurrentFileAction.getMessage(files));
        }
    }

    @NotNull
    private static String getMessage(@NotNull List<VirtualFile> files) {
        if (files == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(0);
        }
        VirtualFile theOnlyOne = files.size() == 1 ? files.get(0) : null;
        String string = theOnlyOne != null ? IdeBundle.message((String)"action.synchronize.file", (Object[])new Object[]{StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)theOnlyOne.getName(), (int)20))}) : IdeBundle.message((String)"action.synchronize.selected.files", (Object[])new Object[0]);
        if (string == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = SynchronizeCurrentFileAction.getEventProject((AnActionEvent)e);
        List files = SynchronizeCurrentFileAction.getFiles(e).toList();
        if (project == null || files.isEmpty()) {
            return;
        }
        for (VirtualFile file2 : files) {
            if (file2.isDirectory()) {
                file2.getChildren();
            }
            if (!(file2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file2).markClean();
            ((NewVirtualFile)file2).markDirtyRecursively();
        }
        RefreshQueue.getInstance().refresh(true, true, () -> SynchronizeCurrentFileAction.postRefresh(project, files), (Collection)files);
    }

    private static void postRefresh(Project project, List<VirtualFile> files) {
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile f : files) {
            if (f.isDirectory()) {
                dirtyScopeManager.dirDirtyRecursively(f);
                continue;
            }
            dirtyScopeManager.fileDirty(f);
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        if (statusBar != null) {
            statusBar.setInfo(IdeBundle.message((String)"action.sync.completed.successfully", (Object[])new Object[]{SynchronizeCurrentFileAction.getMessage(files)}));
        }
    }

    @NotNull
    private static JBIterable<VirtualFile> getFiles(AnActionEvent e) {
        JBIterable jBIterable = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(o -> o.isInLocalFileSystem());
        if (jBIterable == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/SynchronizeCurrentFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/SynchronizeCurrentFileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

