/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class FindUsagesHelper {
    protected static boolean processUsagesInText(final @NotNull PsiElement element, @NotNull Collection<String> stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Processor<UsageInfo> processor2) {
        if (element == null) {
            FindUsagesHelper.$$$reportNull$$$0(0);
        }
        if (stringToSearch == null) {
            FindUsagesHelper.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            FindUsagesHelper.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            FindUsagesHelper.$$$reportNull$$$0(3);
        }
        final TextRange elementTextRange = (TextRange)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            if (element == null) {
                FindUsagesHelper.$$$reportNull$$$0(4);
            }
            if (!element.isValid() || element instanceof PsiCompiledElement) {
                return null;
            }
            return element.getTextRange();
        }));
        UsageInfoFactory factory = new UsageInfoFactory(){

            public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                if (usage == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!element.isValid()) {
                    return new UsageInfo(usage, startOffset, endOffset, true);
                }
                if (elementTextRange != null && usage.getContainingFile() == element.getContainingFile() && elementTextRange.contains(startOffset) && elementTextRange.contains(endOffset)) {
                    return null;
                }
                PsiReference someReference = usage.findReferenceAt(startOffset);
                if (someReference != null) {
                    PsiElement refElement = someReference.getElement();
                    for (PsiReference ref : PsiReferenceService.getService().getReferences(refElement, new PsiReferenceService.Hints(element, null))) {
                        if (!element.getManager().areElementsEquivalent(ref.resolve(), element)) continue;
                        TextRange range = ref.getRangeInElement().shiftRight(refElement.getTextRange().getStartOffset() - usage.getTextRange().getStartOffset());
                        return new UsageInfo(usage, range.getStartOffset(), range.getEndOffset(), true);
                    }
                }
                return new UsageInfo(usage, startOffset, endOffset, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/find/findUsages/FindUsagesHelper$1", "createUsageInfo"));
            }
        };
        for (String s : stringToSearch) {
            if (PsiSearchHelperImpl.processTextOccurrences(element, s, searchScope, processor2, factory)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToSearch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/findUsages/FindUsagesHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processUsagesInText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processUsagesInText$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

