/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.highlighting;

import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.application.options.colors.highlighting.InlineElementData;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class HighlightsExtractor {
    private final Map<String, TextAttributesKey> myTags;
    private final Map<String, TextAttributesKey> myInlineElements;
    private int myStartOffset;
    private int myEndOffset;
    private int mySkippedLen;
    private int myIndex;
    private boolean myIsOpeningTag;
    private List<TextRange> mySkipped = new ArrayList<TextRange>();

    public HighlightsExtractor(@Nullable Map<String, TextAttributesKey> tags) {
        this(tags, null);
    }

    public HighlightsExtractor(@Nullable Map<String, TextAttributesKey> tags, @Nullable Map<String, TextAttributesKey> inlineElements) {
        this.myTags = tags;
        this.myInlineElements = inlineElements;
    }

    public String extractHighlights(String text, List<HighlightData> highlights) {
        String tagName;
        this.mySkipped.clear();
        if (ContainerUtil.isEmpty(this.myTags) && ContainerUtil.isEmpty(this.myInlineElements)) {
            return text;
        }
        this.resetIndices();
        Stack highlightsStack = new Stack();
        while ((tagName = this.findTagName(text)) != null && this.myIndex >= 0) {
            HighlightData highlightData;
            String tagNameWithoutParameters = StringUtil.substringBefore((String)tagName, (String)" ");
            if (this.myInlineElements != null && tagNameWithoutParameters != null && this.myInlineElements.containsKey(tagNameWithoutParameters)) {
                this.mySkippedLen += tagName.length() + 2;
                String hintText = tagName.substring(tagNameWithoutParameters.length()).trim();
                highlights.add(new InlineElementData(this.myStartOffset - this.mySkippedLen, this.myInlineElements.get(tagNameWithoutParameters), hintText));
                continue;
            }
            if (this.myTags == null || !this.myTags.containsKey(tagName)) continue;
            if (this.myIsOpeningTag) {
                this.mySkippedLen += tagName.length() + 2;
                highlightData = new HighlightData(this.myStartOffset - this.mySkippedLen, this.myTags.get(tagName));
                highlightsStack.push((Object)highlightData);
                continue;
            }
            highlightData = (HighlightData)highlightsStack.pop();
            highlightData.setEndOffset(this.myEndOffset - this.mySkippedLen);
            this.mySkippedLen += tagName.length() + 3;
            highlights.add(highlightData);
        }
        return this.cutDefinedTags(text);
    }

    private String findTagName(String text) {
        this.myIsOpeningTag = true;
        int openTag = text.indexOf(60, this.myIndex);
        if (openTag == -1) {
            return null;
        }
        while (text.charAt(openTag + 1) == '<') {
            ++openTag;
        }
        if (text.charAt(openTag + 1) == '/') {
            this.myIsOpeningTag = false;
            ++openTag;
        }
        if (!HighlightsExtractor.isValidTagFirstChar(text.charAt(openTag + 1))) {
            this.myIndex = openTag + 1;
            return "";
        }
        int closeTag = text.indexOf(62, openTag + 1);
        if (closeTag == -1) {
            return null;
        }
        int i = text.indexOf(60, openTag + 1);
        if (i != -1 && i < closeTag) {
            this.myIndex = i;
            return "";
        }
        String tagName = text.substring(openTag + 1, closeTag);
        if (this.myIsOpeningTag) {
            this.myStartOffset = openTag + tagName.length() + 2;
            if (this.myTags != null && this.myTags.containsKey(tagName) || this.myInlineElements != null && this.myInlineElements.containsKey(StringUtil.substringBefore((String)tagName, (String)" "))) {
                this.mySkipped.add(TextRange.from((int)openTag, (int)(tagName.length() + 2)));
            }
        } else {
            this.myEndOffset = openTag - 1;
            if (this.myTags != null && this.myTags.containsKey(tagName)) {
                this.mySkipped.add(TextRange.from((int)(openTag - 1), (int)(tagName.length() + 3)));
            }
        }
        this.myIndex = Math.max(this.myStartOffset, this.myEndOffset + 1);
        return tagName;
    }

    private static boolean isValidTagFirstChar(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private String cutDefinedTags(String text) {
        StringBuilder builder = new StringBuilder(text);
        for (int i = this.mySkipped.size() - 1; i >= 0; --i) {
            TextRange range = this.mySkipped.get(i);
            builder.delete(range.getStartOffset(), range.getEndOffset());
        }
        return builder.toString();
    }

    private void resetIndices() {
        this.myIndex = 0;
        this.myStartOffset = 0;
        this.myEndOffset = 0;
        this.mySkippedLen = 0;
    }
}

