/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.util.gui.ExtendedGridBagConstraints;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.resources.ResourceManager;

public class URIChooser
extends JDialog
implements ActionMap {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected static final String RESOURCES = "org.apache.batik.util.gui.resources.URIChooserMessages";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.util.gui.resources.URIChooserMessages", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected ButtonFactory buttonFactory;
    protected JTextField textField;
    protected JButton okButton;
    protected JButton clearButton;
    protected String currentPath = ".";
    protected FileFilter fileFilter;
    protected int returnCode;
    protected String chosenPath;
    protected Map listeners = new HashMap(10);

    public URIChooser(JDialog jDialog) {
        super(jDialog);
        this.initialize();
    }

    public URIChooser(JFrame jFrame) {
        super(jFrame);
        this.initialize();
    }

    public int showDialog() {
        this.pack();
        this.setVisible(true);
        return this.returnCode;
    }

    public String getText() {
        return this.chosenPath;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    protected void initialize() {
        this.setModal(true);
        this.listeners.put("BrowseButtonAction", new BrowseButtonAction());
        this.listeners.put("OKButtonAction", new OKButtonAction());
        this.listeners.put("CancelButtonAction", new CancelButtonAction());
        this.listeners.put("ClearButtonAction", new ClearButtonAction());
        this.setTitle(resources.getString("Dialog.title"));
        this.buttonFactory = new ButtonFactory(bundle, this);
        this.getContentPane().add((Component)this.createURISelectionPanel(), "North");
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
    }

    protected JPanel createURISelectionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ExtendedGridBagConstraints extendedGridBagConstraints = new ExtendedGridBagConstraints();
        extendedGridBagConstraints.insets = new Insets(5, 5, 5, 5);
        extendedGridBagConstraints.weightx = 0.0;
        extendedGridBagConstraints.weighty = 0.0;
        extendedGridBagConstraints.fill = 2;
        extendedGridBagConstraints.setGridBounds(0, 0, 2, 1);
        jPanel.add((Component)new JLabel(resources.getString("Dialog.label")), extendedGridBagConstraints);
        this.textField = new JTextField(30);
        this.textField.getDocument().addDocumentListener(new DocumentAdapter());
        extendedGridBagConstraints.weightx = 1.0;
        extendedGridBagConstraints.weighty = 0.0;
        extendedGridBagConstraints.fill = 2;
        extendedGridBagConstraints.setGridBounds(0, 1, 1, 1);
        jPanel.add((Component)this.textField, extendedGridBagConstraints);
        extendedGridBagConstraints.weightx = 0.0;
        extendedGridBagConstraints.weighty = 0.0;
        extendedGridBagConstraints.fill = 0;
        extendedGridBagConstraints.setGridBounds(1, 1, 1, 1);
        jPanel.add((Component)this.buttonFactory.createJButton("BrowseButton"), extendedGridBagConstraints);
        return jPanel;
    }

    protected JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        this.okButton = this.buttonFactory.createJButton("OKButton");
        jPanel.add(this.okButton);
        jPanel.add(this.buttonFactory.createJButton("CancelButton"));
        this.clearButton = this.buttonFactory.createJButton("ClearButton");
        jPanel.add(this.clearButton);
        this.okButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        return jPanel;
    }

    protected void updateOKButtonAction() {
        this.okButton.setEnabled(!this.textField.getText().equals(""));
    }

    protected void updateClearButtonAction() {
        this.clearButton.setEnabled(!this.textField.getText().equals(""));
    }

    @Override
    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    protected class ClearButtonAction
    extends AbstractAction {
        protected ClearButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URIChooser.this.textField.setText("");
        }
    }

    protected class CancelButtonAction
    extends AbstractAction {
        protected CancelButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URIChooser.this.returnCode = 1;
            URIChooser.this.dispose();
            URIChooser.this.textField.setText(URIChooser.this.chosenPath);
        }
    }

    protected class OKButtonAction
    extends AbstractAction {
        protected OKButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URIChooser.this.returnCode = 0;
            URIChooser.this.chosenPath = URIChooser.this.textField.getText();
            URIChooser.this.dispose();
        }
    }

    protected class BrowseButtonAction
    extends AbstractAction {
        protected BrowseButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JFileChooser jFileChooser = new JFileChooser(URIChooser.this.currentPath);
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(2);
            if (URIChooser.this.fileFilter != null) {
                jFileChooser.setFileFilter(URIChooser.this.fileFilter);
            }
            if ((n = jFileChooser.showOpenDialog(URIChooser.this)) == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    URIChooser.this.currentPath = file.getCanonicalPath();
                    URIChooser.this.textField.setText(URIChooser.this.currentPath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected class DocumentAdapter
    implements DocumentListener {
        protected DocumentAdapter() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            URIChooser.this.updateOKButtonAction();
            URIChooser.this.updateClearButtonAction();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            URIChooser.this.updateOKButtonAction();
            URIChooser.this.updateClearButtonAction();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            URIChooser.this.updateOKButtonAction();
            URIChooser.this.updateClearButtonAction();
        }
    }
}

