/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.batik.ext.awt.geom.Polygon2D;
import org.apache.batik.ext.awt.geom.Polyline2D;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFPainter;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.TextureFactory;
import org.apache.batik.transcoder.wmf.tosvg.WMFFont;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;
import org.apache.batik.transcoder.wmf.tosvg.WMFUtilities;

public class WMFPainter
extends AbstractWMFPainter {
    private static final int INPUT_BUFFER_SIZE = 30720;
    private static final Integer INTEGER_0 = new Integer(0);
    private float scale;
    private float scaleX;
    private float scaleY;
    private float conv;
    private float xOffset;
    private float yOffset;
    private float vpX;
    private float vpY;
    private float vpW;
    private float vpH;
    private Color frgdColor;
    private Color bkgdColor;
    private boolean opaque = false;
    private transient boolean firstEffectivePaint = true;
    private static BasicStroke solid = new BasicStroke(1.0f, 0, 1);
    private static BasicStroke textSolid = new BasicStroke(1.0f, 0, 1);
    private transient ImageObserver observer = new ImageObserver(){

        @Override
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return false;
        }
    };
    private transient BufferedInputStream bufStream = null;

    public WMFPainter(WMFRecordStore wMFRecordStore, float f) {
        this(wMFRecordStore, 0, 0, f);
    }

    public WMFPainter(WMFRecordStore wMFRecordStore, int n, int n2, float f) {
        this.setRecordStore(wMFRecordStore);
        TextureFactory.getInstance().reset();
        this.conv = f;
        this.xOffset = -n;
        this.yOffset = -n2;
        this.scale = (float)wMFRecordStore.getWidthPixels() / (float)wMFRecordStore.getWidthUnits() * f;
        this.scale = this.scale * (float)wMFRecordStore.getWidthPixels() / (float)wMFRecordStore.getVpW();
        float f2 = (float)wMFRecordStore.getVpW() / (float)wMFRecordStore.getWidthPixels() * (float)wMFRecordStore.getWidthUnits() / (float)wMFRecordStore.getWidthPixels();
        float f3 = (float)wMFRecordStore.getVpH() / (float)wMFRecordStore.getHeightPixels() * (float)wMFRecordStore.getHeightUnits() / (float)wMFRecordStore.getHeightPixels();
        this.xOffset *= f2;
        this.yOffset *= f3;
        this.scaleX = this.scale;
        this.scaleY = this.scale;
    }

    public void paint(Graphics graphics) {
        float f = 10.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        Object var10_10 = null;
        Stack<Serializable> stack = new Stack<Serializable>();
        int n4 = this.currentStore.getNumRecords();
        int n5 = this.currentStore.getNumObjects();
        this.vpX = this.currentStore.getVpX() * this.scale;
        this.vpY = this.currentStore.getVpY() * this.scale;
        this.vpW = (float)this.currentStore.getVpW() * this.scale;
        this.vpH = (float)this.currentStore.getVpH() * this.scale;
        if (!this.currentStore.isReading()) {
            GdiObject gdiObject;
            graphics.setPaintMode();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(solid);
            n = -1;
            n2 = -1;
            n3 = -1;
            this.frgdColor = null;
            this.bkgdColor = Color.white;
            for (int i = 0; i < n5; ++i) {
                gdiObject = this.currentStore.getObject(i);
                gdiObject.clear();
            }
            float f6 = this.vpW;
            float f7 = this.vpH;
            graphics2D.setColor(Color.black);
            block58: for (int i = 0; i < n4; ++i) {
                MetaRecord metaRecord = this.currentStore.getRecord(i);
                switch (metaRecord.functionId) {
                    case 523: {
                        this.vpX = -((float)metaRecord.elementAt(0));
                        this.currentStore.setVpX(this.vpX);
                        this.vpY = -((float)metaRecord.elementAt(1));
                        this.currentStore.setVpY(this.vpY);
                        this.vpX *= this.scale;
                        this.vpY *= this.scale;
                        continue block58;
                    }
                    case 0: 
                    case 524: {
                        this.vpW = metaRecord.elementAt(0);
                        this.vpH = metaRecord.elementAt(1);
                        this.scaleX = this.scale;
                        this.scaleY = this.scale;
                        solid = new BasicStroke(this.scaleX * 2.0f, 0, 1);
                        continue block58;
                    }
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 1040: 
                    case 1042: {
                        continue block58;
                    }
                    case 262: {
                        continue block58;
                    }
                    case 762: {
                        Color color;
                        int n6 = 0;
                        int n7 = metaRecord.elementAt(0);
                        if (n7 == 5) {
                            color = Color.white;
                            n6 = this.addObjectAt(this.currentStore, 4, color, n6);
                            continue block58;
                        }
                        f3 = metaRecord.elementAt(4);
                        this.setStroke(graphics2D, n7, f3, this.scaleX);
                        color = new Color(metaRecord.elementAt(1), metaRecord.elementAt(2), metaRecord.elementAt(3));
                        n6 = this.addObjectAt(this.currentStore, 1, color, n6);
                        continue block58;
                    }
                    case 764: {
                        int n8 = 0;
                        int n9 = metaRecord.elementAt(0);
                        Color color = new Color(metaRecord.elementAt(1), metaRecord.elementAt(2), metaRecord.elementAt(3));
                        if (n9 == 0) {
                            n8 = this.addObjectAt(this.currentStore, 2, color, n8);
                            continue block58;
                        }
                        if (n9 == 2) {
                            int n10 = metaRecord.elementAt(4);
                            Paint paint = !this.opaque ? TextureFactory.getInstance().getTexture(n10, color) : TextureFactory.getInstance().getTexture(n10, color, this.bkgdColor);
                            if (paint != null) {
                                n8 = this.addObjectAt(this.currentStore, 2, paint, n8);
                                continue block58;
                            }
                            color = Color.black;
                            n8 = this.addObjectAt(this.currentStore, 5, color, n8);
                            continue block58;
                        }
                        color = Color.black;
                        n8 = this.addObjectAt(this.currentStore, 5, color, n8);
                        continue block58;
                    }
                    case 763: {
                        int n11;
                        float f8 = (int)(this.scaleY * (float)metaRecord.elementAt(0));
                        int n12 = metaRecord.elementAt(3);
                        int n13 = metaRecord.elementAt(1);
                        int n14 = metaRecord.elementAt(2);
                        int n15 = n13 > 0 ? 2 : 0;
                        n15 |= n14 > 400 ? 1 : 0;
                        String string = ((MetaRecord.StringRecord)metaRecord).text;
                        for (n11 = 0; n11 < string.length() && (Character.isLetterOrDigit(string.charAt(n11)) || Character.isWhitespace(string.charAt(n11))); ++n11) {
                        }
                        string = n11 > 0 ? string.substring(0, n11) : "System";
                        if (f8 < 0.0f) {
                            f8 = -f8;
                        }
                        int n16 = 0;
                        f = f8;
                        Font font = new Font(string, n15, (int)f8);
                        font = font.deriveFont(f8);
                        int n17 = metaRecord.elementAt(4);
                        int n18 = metaRecord.elementAt(5);
                        int n19 = metaRecord.elementAt(6);
                        int n20 = metaRecord.elementAt(7);
                        WMFFont wMFFont = new WMFFont(font, n12, n17, n18, n13, n14, n19, n20);
                        n16 = this.addObjectAt(this.currentStore, 3, wMFFont, n16);
                        continue block58;
                    }
                    case 248: 
                    case 505: 
                    case 765: 
                    case 1790: 
                    case 1791: {
                        int n21 = this.addObjectAt(this.currentStore, 6, INTEGER_0, 0);
                        continue block58;
                    }
                    case 247: {
                        int n22 = this.addObjectAt(this.currentStore, 8, INTEGER_0, 0);
                        continue block58;
                    }
                    case 53: 
                    case 55: 
                    case 313: 
                    case 564: 
                    case 1078: {
                        continue block58;
                    }
                    case 301: {
                        int n23 = metaRecord.elementAt(0);
                        if ((n23 & Integer.MIN_VALUE) != 0) continue block58;
                        if (n23 >= n5) {
                            switch (n23 -= n5) {
                                case 5: {
                                    n = -1;
                                    continue block58;
                                }
                                case 8: {
                                    n2 = -1;
                                    continue block58;
                                }
                            }
                            continue block58;
                        }
                        gdiObject = this.currentStore.getObject(n23);
                        if (!gdiObject.used) continue block58;
                        switch (gdiObject.type) {
                            case 1: {
                                graphics2D.setColor((Color)gdiObject.obj);
                                n2 = n23;
                                break;
                            }
                            case 2: {
                                if (gdiObject.obj instanceof Color) {
                                    graphics2D.setColor((Color)gdiObject.obj);
                                } else if (gdiObject.obj instanceof Paint) {
                                    graphics2D.setPaint((Paint)gdiObject.obj);
                                } else {
                                    graphics2D.setPaint(this.getPaint((byte[])gdiObject.obj));
                                }
                                n = n23;
                                break;
                            }
                            case 3: {
                                this.wmfFont = (WMFFont)gdiObject.obj;
                                Font font = this.wmfFont.font;
                                graphics2D.setFont(font);
                                n3 = n23;
                                break;
                            }
                            case 4: {
                                n2 = -1;
                                break;
                            }
                            case 5: {
                                n = -1;
                            }
                        }
                        continue block58;
                    }
                    case 496: {
                        int n23 = metaRecord.elementAt(0);
                        gdiObject = this.currentStore.getObject(n23);
                        if (n23 == n) {
                            n = -1;
                        } else if (n23 == n2) {
                            n2 = -1;
                        } else if (n23 == n3) {
                            n3 = -1;
                        }
                        gdiObject.clear();
                        continue block58;
                    }
                    case 1336: {
                        int n24;
                        int n25 = metaRecord.elementAt(0);
                        int[] nArray = new int[n25];
                        for (n24 = 0; n24 < n25; ++n24) {
                            nArray[n24] = metaRecord.elementAt(n24 + 1);
                        }
                        n24 = n25 + 1;
                        ArrayList<Polygon2D> arrayList = new ArrayList<Polygon2D>(n25);
                        for (int j = 0; j < n25; ++j) {
                            int n26 = nArray[j];
                            float[] fArray = new float[n26];
                            float[] fArray2 = new float[n26];
                            for (int k = 0; k < n26; ++k) {
                                fArray[k] = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(n24 + k * 2));
                                fArray2[k] = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(n24 + k * 2 + 1));
                            }
                            n24 += n26 * 2;
                            Polygon2D polygon2D = new Polygon2D(fArray, fArray2, n26);
                            arrayList.add(polygon2D);
                        }
                        if (n >= 0) {
                            this.setBrushPaint(this.currentStore, graphics2D, n);
                            this.fillPolyPolygon(graphics2D, arrayList);
                            this.firstEffectivePaint = false;
                        }
                        if (n2 < 0) continue block58;
                        this.setPenColor(this.currentStore, graphics2D, n2);
                        this.drawPolyPolygon(graphics2D, arrayList);
                        this.firstEffectivePaint = false;
                        continue block58;
                    }
                    case 804: {
                        int n27 = metaRecord.elementAt(0);
                        float[] fArray = new float[n27];
                        float[] fArray3 = new float[n27];
                        for (int j = 0; j < n27; ++j) {
                            fArray[j] = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(j * 2 + 1));
                            fArray3[j] = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(j * 2 + 2));
                        }
                        Polygon2D polygon2D = new Polygon2D(fArray, fArray3, n27);
                        this.paint(n, n2, polygon2D, graphics2D);
                        continue block58;
                    }
                    case 532: {
                        f4 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        f5 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        continue block58;
                    }
                    case 531: {
                        float f9 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        float f10 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        Line2D.Float float_ = new Line2D.Float(f4, f5, f9, f10);
                        this.paintWithPen(n2, float_, graphics2D);
                        f4 = f9;
                        f5 = f10;
                        continue block58;
                    }
                    case 805: {
                        int n28 = metaRecord.elementAt(0);
                        float[] fArray = new float[n28];
                        float[] fArray4 = new float[n28];
                        for (int j = 0; j < n28; ++j) {
                            fArray[j] = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(j * 2 + 1));
                            fArray4[j] = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(j * 2 + 2));
                        }
                        Polyline2D polyline2D = new Polyline2D(fArray, fArray4, n28);
                        this.paintWithPen(n2, polyline2D, graphics2D);
                        continue block58;
                    }
                    case 1051: {
                        float f11 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        float f12 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(2));
                        float f13 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        float f14 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(3));
                        Rectangle2D.Float float_ = new Rectangle2D.Float(f11, f13, f12 - f11, f14 - f13);
                        this.paint(n, n2, float_, graphics2D);
                        continue block58;
                    }
                    case 1564: {
                        float f15 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        float f16 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(2));
                        float f17 = this.scaleX * (float)metaRecord.elementAt(4);
                        float f18 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        float f19 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(3));
                        float f20 = this.scaleY * (float)metaRecord.elementAt(5);
                        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(f15, f18, f16 - f15, f19 - f18, f17, f20);
                        this.paint(n, n2, float_, graphics2D);
                        continue block58;
                    }
                    case 1048: {
                        float f21 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        float f22 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(2));
                        float f23 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        float f24 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(3));
                        Ellipse2D.Float float_ = new Ellipse2D.Float(f21, f23, f22 - f21, f24 - f23);
                        this.paint(n, n2, float_, graphics2D);
                        continue block58;
                    }
                    case 302: {
                        this.currentHorizAlign = WMFUtilities.getHorizontalAlignment(metaRecord.elementAt(0));
                        this.currentVertAlign = WMFUtilities.getVerticalAlignment(metaRecord.elementAt(0));
                        continue block58;
                    }
                    case 521: {
                        this.frgdColor = new Color(metaRecord.elementAt(0), metaRecord.elementAt(1), metaRecord.elementAt(2));
                        graphics2D.setColor(this.frgdColor);
                        continue block58;
                    }
                    case 513: {
                        this.bkgdColor = new Color(metaRecord.elementAt(0), metaRecord.elementAt(1), metaRecord.elementAt(2));
                        graphics2D.setColor(this.bkgdColor);
                        continue block58;
                    }
                    case 2610: {
                        int n19;
                        try {
                            byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                            String string = WMFUtilities.decodeString(this.wmfFont, byArray);
                            float f25 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                            float f26 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                            if (this.frgdColor != null) {
                                graphics2D.setColor(this.frgdColor);
                            } else {
                                graphics2D.setColor(Color.black);
                            }
                            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
                            GeneralPath generalPath = new GeneralPath(1);
                            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), fontRenderContext);
                            int n29 = metaRecord.elementAt(2);
                            int n30 = 0;
                            int n31 = 0;
                            n19 = 0;
                            int n32 = 0;
                            boolean bl = false;
                            Shape shape = null;
                            if ((n29 & 4) != 0) {
                                bl = true;
                                n30 = metaRecord.elementAt(3);
                                n31 = metaRecord.elementAt(4);
                                n19 = metaRecord.elementAt(5);
                                n32 = metaRecord.elementAt(6);
                                shape = graphics2D.getClip();
                                graphics2D.setClip(n30, n31, n19, n32);
                            }
                            this.firstEffectivePaint = false;
                            this.drawString(n29, graphics2D, this.getCharacterIterator(graphics2D, string, this.wmfFont, this.currentHorizAlign), f25, f26 += this.getVerticalAlignmentValue(textLayout, this.currentVertAlign), textLayout, this.wmfFont, this.currentHorizAlign);
                            if (!bl) continue block58;
                            graphics2D.setClip(shape);
                        }
                        catch (Exception exception) {}
                        continue block58;
                    }
                    case 1313: 
                    case 1583: {
                        try {
                            byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                            String string = WMFUtilities.decodeString(this.wmfFont, byArray);
                            float f27 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                            float f28 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                            if (this.frgdColor != null) {
                                graphics2D.setColor(this.frgdColor);
                            } else {
                                graphics2D.setColor(Color.black);
                            }
                            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
                            GeneralPath generalPath = new GeneralPath(1);
                            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), fontRenderContext);
                            this.firstEffectivePaint = false;
                            this.drawString(-1, graphics2D, this.getCharacterIterator(graphics2D, string, this.wmfFont), f27, f28 += this.getVerticalAlignmentValue(textLayout, this.currentVertAlign), textLayout, this.wmfFont, this.currentHorizAlign);
                        }
                        catch (Exception exception) {}
                        continue block58;
                    }
                    case 2071: 
                    case 2074: {
                        double d = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        double d2 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        double d3 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(2));
                        double d4 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(3));
                        double d5 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(4));
                        double d6 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(5));
                        double d7 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(6));
                        double d8 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(7));
                        this.setBrushPaint(this.currentStore, graphics2D, n);
                        double d9 = d + (d3 - d) / 2.0;
                        double d10 = d2 + (d4 - d2) / 2.0;
                        double d11 = -Math.toDegrees(Math.atan2(d6 - d10, d5 - d9));
                        double d12 = -Math.toDegrees(Math.atan2(d8 - d10, d7 - d9));
                        double d13 = d12 - d11;
                        if (d13 < 0.0) {
                            d13 += 360.0;
                        }
                        if (d11 < 0.0) {
                            d11 += 360.0;
                        }
                        Arc2D.Double double_ = new Arc2D.Double(d, d2, d3 - d, d4 - d2, d11, d13, 0);
                        if (metaRecord.functionId == 2071) {
                            graphics2D.draw(double_);
                        } else {
                            graphics2D.fill(double_);
                        }
                        this.firstEffectivePaint = false;
                        continue block58;
                    }
                    case 2096: {
                        double d = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        double d14 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        double d15 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(2));
                        double d16 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(3));
                        double d17 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(4));
                        double d18 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(5));
                        double d19 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(6));
                        double d20 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(7));
                        this.setBrushPaint(this.currentStore, graphics2D, n);
                        double d9 = d + (d15 - d) / 2.0;
                        double d10 = d14 + (d16 - d14) / 2.0;
                        double d11 = -Math.toDegrees(Math.atan2(d18 - d10, d17 - d9));
                        double d12 = -Math.toDegrees(Math.atan2(d20 - d10, d19 - d9));
                        double d13 = d12 - d11;
                        if (d13 < 0.0) {
                            d13 += 360.0;
                        }
                        if (d11 < 0.0) {
                            d11 += 360.0;
                        }
                        Arc2D.Double double_ = new Arc2D.Double(d, d14, d15 - d, d16 - d14, d11, d13, 1);
                        this.paint(n, n2, double_, graphics2D);
                        this.firstEffectivePaint = false;
                        continue block58;
                    }
                    case 30: {
                        stack.push(new Float(f3));
                        stack.push(new Float(f4));
                        stack.push(new Float(f5));
                        stack.push(new Integer(n));
                        stack.push(new Integer(n2));
                        stack.push(new Integer(n3));
                        stack.push(this.frgdColor);
                        stack.push(this.bkgdColor);
                        continue block58;
                    }
                    case 295: {
                        this.bkgdColor = (Color)stack.pop();
                        this.frgdColor = (Color)stack.pop();
                        n3 = (Integer)stack.pop();
                        n2 = (Integer)stack.pop();
                        n = (Integer)stack.pop();
                        f5 = ((Float)stack.pop()).floatValue();
                        f4 = ((Float)stack.pop()).floatValue();
                        f3 = ((Float)stack.pop()).floatValue();
                        continue block58;
                    }
                    case 4096: {
                        try {
                            this.setPenColor(this.currentStore, graphics2D, n2);
                            int n33 = metaRecord.elementAt(0);
                            int n34 = (n33 - 1) / 3;
                            float f29 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(1));
                            float f30 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(2));
                            GeneralPath generalPath = new GeneralPath(1);
                            generalPath.moveTo(f29, f30);
                            for (int j = 0; j < n34; ++j) {
                                int n35 = j * 6;
                                float f31 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(n35 + 3));
                                float f32 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(n35 + 4));
                                float f33 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(n35 + 5));
                                float f34 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(n35 + 6));
                                float f35 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(n35 + 7));
                                float f36 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(n35 + 8));
                                generalPath.curveTo(f31, f32, f33, f34, f35, f36);
                                f29 = f35;
                                f30 = f36;
                            }
                            graphics2D.setStroke(solid);
                            graphics2D.draw(generalPath);
                            this.firstEffectivePaint = false;
                        }
                        catch (Exception exception) {}
                        continue block58;
                    }
                    case 259: 
                    case 261: 
                    case 263: 
                    case 264: 
                    case 300: 
                    case 522: 
                    case 544: 
                    case 1045: 
                    case 1046: 
                    case 1049: {
                        continue block58;
                    }
                    case 258: {
                        int n36 = metaRecord.elementAt(0);
                        this.opaque = n36 == 2;
                        continue block58;
                    }
                    case 260: {
                        float f37 = metaRecord.ElementAt(0).intValue();
                        Paint paint = null;
                        boolean bl = false;
                        if (f37 == 66.0f) {
                            paint = Color.black;
                            bl = true;
                        } else if (f37 == 1.6711778E7f) {
                            paint = Color.white;
                            bl = true;
                        } else if (f37 == 1.5728673E7f && n >= 0) {
                            paint = this.getStoredPaint(this.currentStore, n);
                            bl = true;
                        }
                        if (!bl) continue block58;
                        if (paint != null) {
                            graphics2D.setPaint(paint);
                            continue block58;
                        }
                        this.setBrushPaint(this.currentStore, graphics2D, n);
                        continue block58;
                    }
                    case 1565: {
                        float f38 = metaRecord.elementAt(0);
                        float f39 = this.scaleY * (float)metaRecord.elementAt(1);
                        float f40 = this.scaleX * (float)metaRecord.elementAt(2);
                        float f41 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(3));
                        float f42 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(4));
                        Paint paint = null;
                        boolean bl = false;
                        if (f38 == 66.0f) {
                            paint = Color.black;
                            bl = true;
                        } else if (f38 == 1.6711778E7f) {
                            paint = Color.white;
                            bl = true;
                        } else if (f38 == 1.5728673E7f && n >= 0) {
                            paint = this.getStoredPaint(this.currentStore, n);
                            bl = true;
                        }
                        if (!bl) continue block58;
                        Color color = graphics2D.getColor();
                        if (paint != null) {
                            graphics2D.setPaint(paint);
                        } else {
                            this.setBrushPaint(this.currentStore, graphics2D, n);
                        }
                        Rectangle2D.Float float_ = new Rectangle2D.Float(f41, f42, f40, f39);
                        graphics2D.fill(float_);
                        graphics2D.setColor(color);
                        continue block58;
                    }
                    case 2881: {
                        int n37 = metaRecord.elementAt(1);
                        int n38 = metaRecord.elementAt(2);
                        int n39 = metaRecord.elementAt(3);
                        int n40 = metaRecord.elementAt(4);
                        float f43 = this.conv * this.currentStore.getVpWFactor() * (this.vpY + this.yOffset + (float)metaRecord.elementAt(7));
                        float f44 = this.conv * this.currentStore.getVpHFactor() * (this.vpX + this.xOffset + (float)metaRecord.elementAt(8));
                        float f45 = metaRecord.elementAt(5);
                        float f46 = metaRecord.elementAt(6);
                        f46 = f46 * this.conv * this.currentStore.getVpWFactor();
                        f45 = f45 * this.conv * this.currentStore.getVpHFactor();
                        byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                        BufferedImage bufferedImage = this.getImage(byArray, n38, n37);
                        if (bufferedImage == null) continue block58;
                        graphics2D.drawImage(bufferedImage, (int)f44, (int)f43, (int)(f44 + f46), (int)(f43 + f45), n40, n39, n40 + n38, n39 + n37, this.bkgdColor, this.observer);
                        continue block58;
                    }
                    case 3907: {
                        int n41 = metaRecord.elementAt(1);
                        int n42 = metaRecord.elementAt(2);
                        int n43 = metaRecord.elementAt(3);
                        int n44 = metaRecord.elementAt(4);
                        float f47 = this.conv * this.currentStore.getVpWFactor() * (this.vpY + this.yOffset + (float)metaRecord.elementAt(7));
                        float f48 = this.conv * this.currentStore.getVpHFactor() * (this.vpX + this.xOffset + (float)metaRecord.elementAt(8));
                        float f49 = metaRecord.elementAt(5);
                        float f50 = metaRecord.elementAt(6);
                        f50 = f50 * this.conv * this.currentStore.getVpWFactor();
                        f49 = f49 * this.conv * this.currentStore.getVpHFactor();
                        byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                        BufferedImage bufferedImage = this.getImage(byArray, n42, n41);
                        if (bufferedImage == null) continue block58;
                        if (this.opaque) {
                            graphics2D.drawImage(bufferedImage, (int)f48, (int)f47, (int)(f48 + f50), (int)(f47 + f49), n44, n43, n44 + n42, n43 + n41, this.bkgdColor, this.observer);
                            continue block58;
                        }
                        graphics2D.drawImage(bufferedImage, (int)f48, (int)f47, (int)(f48 + f50), (int)(f47 + f49), n44, n43, n44 + n42, n43 + n41, this.observer);
                        continue block58;
                    }
                    case 2368: {
                        int n45 = metaRecord.ElementAt(0);
                        float f51 = (float)metaRecord.ElementAt(1).intValue() * this.conv * this.currentStore.getVpWFactor();
                        float f52 = (float)metaRecord.ElementAt(2).intValue() * this.conv * this.currentStore.getVpHFactor();
                        int n46 = metaRecord.ElementAt(3);
                        int n47 = metaRecord.ElementAt(4);
                        float f53 = this.conv * this.currentStore.getVpWFactor() * (this.vpY + this.yOffset + (float)metaRecord.ElementAt(5).intValue());
                        float f54 = this.conv * this.currentStore.getVpHFactor() * (this.vpX + this.xOffset + (float)metaRecord.ElementAt(6).intValue());
                        if (metaRecord instanceof MetaRecord.ByteRecord) {
                            byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                            BufferedImage bufferedImage = this.getImage(byArray);
                            if (bufferedImage == null) continue block58;
                            int n48 = bufferedImage.getWidth();
                            int n49 = bufferedImage.getHeight();
                            if (this.opaque) {
                                graphics2D.drawImage(bufferedImage, (int)f54, (int)f53, (int)(f54 + f52), (int)(f53 + f51), n47, n46, n47 + n48, n46 + n49, this.bkgdColor, this.observer);
                                continue block58;
                            }
                            graphics2D.drawImage(bufferedImage, (int)f54, (int)f53, (int)(f54 + f52), (int)(f53 + f51), n47, n46, n47 + n48, n46 + n49, this.observer);
                            continue block58;
                        }
                        if (!this.opaque) continue block58;
                        Color color = graphics2D.getColor();
                        graphics2D.setColor(this.bkgdColor);
                        graphics2D.fill(new Rectangle2D.Float(f54, f53, f52, f51));
                        graphics2D.setColor(color);
                        continue block58;
                    }
                    case 322: {
                        int n50 = 0;
                        byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                        n50 = this.addObjectAt(this.currentStore, 2, byArray, n50);
                        continue block58;
                    }
                }
            }
        }
    }

    private Paint getPaint(byte[] byArray) {
        Dimension dimension = this.getImageDimension(byArray);
        BufferedImage bufferedImage = this.getImage(byArray);
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height);
        TexturePaint texturePaint = new TexturePaint(bufferedImage, float_);
        return texturePaint;
    }

    private void drawString(int n, Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator, float f, float f2, TextLayout textLayout, WMFFont wMFFont, int n2) {
        if (wMFFont.escape == 0) {
            if (n != -1) {
                this.fillTextBackground(-1, n, graphics2D, f, f2, 0.0f, textLayout);
            }
            float f3 = (float)textLayout.getBounds().getWidth();
            if (n2 == 6) {
                graphics2D.drawString(attributedCharacterIterator, f - f3 / 2.0f, f2);
            } else if (n2 == 2) {
                graphics2D.drawString(attributedCharacterIterator, f - f3, f2);
            } else {
                graphics2D.drawString(attributedCharacterIterator, f, f2);
            }
        } else {
            AffineTransform affineTransform = graphics2D.getTransform();
            float f4 = -((float)((double)wMFFont.escape * Math.PI / 1800.0));
            float f5 = (float)textLayout.getBounds().getWidth();
            float f6 = (float)textLayout.getBounds().getHeight();
            if (n2 == 6) {
                graphics2D.translate(-f5 / 2.0f, f6 / 2.0f);
                graphics2D.rotate(f4, f - f5 / 2.0f, f2);
            } else if (n2 == 2) {
                graphics2D.translate(-f5 / 2.0f, f6 / 2.0f);
                graphics2D.rotate(f4, f - f5, f2);
            } else {
                graphics2D.translate(0.0, f6 / 2.0f);
                graphics2D.rotate(f4, f, f2);
            }
            if (n != -1) {
                this.fillTextBackground(n2, n, graphics2D, f, f2, f5, textLayout);
            }
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(textSolid);
            graphics2D.drawString(attributedCharacterIterator, f, f2);
            graphics2D.setStroke(stroke);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void fillTextBackground(int n, int n2, Graphics2D graphics2D, float f, float f2, float f3, TextLayout textLayout) {
        float f4 = f;
        if (n == 6) {
            f4 = f - f3 / 2.0f;
        } else if (n == 2) {
            f4 = f - f3;
        }
        if ((n2 & 2) != 0) {
            Color color = graphics2D.getColor();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setColor(this.bkgdColor);
            graphics2D.translate(f4, f2);
            graphics2D.fill(textLayout.getBounds());
            graphics2D.setColor(color);
            graphics2D.setTransform(affineTransform);
        } else if (this.opaque) {
            Color color = graphics2D.getColor();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setColor(this.bkgdColor);
            graphics2D.translate(f4, f2);
            graphics2D.fill(textLayout.getBounds());
            graphics2D.setColor(color);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void drawPolyPolygon(Graphics2D graphics2D, List list) {
        for (Polygon2D polygon2D : list) {
            graphics2D.draw(polygon2D);
        }
    }

    private void fillPolyPolygon(Graphics2D graphics2D, List list) {
        if (list.size() == 1) {
            graphics2D.fill((Polygon2D)list.get(0));
        } else {
            GeneralPath generalPath = new GeneralPath(0);
            for (int i = 0; i < list.size(); ++i) {
                Polygon2D polygon2D = (Polygon2D)list.get(i);
                generalPath.append(polygon2D, false);
            }
            graphics2D.fill(generalPath);
        }
    }

    private void setStroke(Graphics2D graphics2D, int n, float f, float f2) {
        float f3 = f == 0.0f ? 1.0f : f;
        float f4 = (float)Toolkit.getDefaultToolkit().getScreenResolution() / (float)this.currentStore.getMetaFileUnitsPerInch();
        float f5 = f2 / f4;
        f3 = f3 * f4 * f5;
        f4 = (float)this.currentStore.getWidthPixels() * 1.0f / 350.0f;
        if (n == 0) {
            BasicStroke basicStroke = new BasicStroke(f3, 0, 1);
            graphics2D.setStroke(basicStroke);
        } else if (n == 2) {
            float[] fArray = new float[]{1.0f * f4, 5.0f * f4};
            BasicStroke basicStroke = new BasicStroke(f3, 0, 1, 10.0f * f4, fArray, 0.0f);
            graphics2D.setStroke(basicStroke);
        } else if (n == 1) {
            float[] fArray = new float[]{5.0f * f4, 2.0f * f4};
            BasicStroke basicStroke = new BasicStroke(f3, 0, 1, 10.0f * f4, fArray, 0.0f);
            graphics2D.setStroke(basicStroke);
        } else if (n == 3) {
            float[] fArray = new float[]{5.0f * f4, 2.0f * f4, 1.0f * f4, 2.0f * f4};
            BasicStroke basicStroke = new BasicStroke(f3, 0, 1, 10.0f * f4, fArray, 0.0f);
            graphics2D.setStroke(basicStroke);
        } else if (n == 4) {
            float[] fArray = new float[]{5.0f * f4, 2.0f * f4, 1.0f * f4, 2.0f * f4, 1.0f * f4, 2.0f * f4};
            BasicStroke basicStroke = new BasicStroke(f3, 0, 1, 15.0f * f4, fArray, 0.0f);
            graphics2D.setStroke(basicStroke);
        } else {
            BasicStroke basicStroke = new BasicStroke(f3, 0, 1);
            graphics2D.setStroke(basicStroke);
        }
    }

    private void setPenColor(WMFRecordStore wMFRecordStore, Graphics2D graphics2D, int n) {
        if (n >= 0) {
            GdiObject gdiObject = wMFRecordStore.getObject(n);
            graphics2D.setColor((Color)gdiObject.obj);
            n = -1;
        }
    }

    private int getHorizontalAlignement(int n) {
        int n2 = n;
        n2 %= 24;
        if ((n2 %= 8) >= 6) {
            return 6;
        }
        if (n2 >= 2) {
            return 2;
        }
        return 0;
    }

    private void setBrushPaint(WMFRecordStore wMFRecordStore, Graphics2D graphics2D, int n) {
        if (n >= 0) {
            GdiObject gdiObject = wMFRecordStore.getObject(n);
            if (gdiObject.obj instanceof Color) {
                graphics2D.setColor((Color)gdiObject.obj);
            } else if (gdiObject.obj instanceof Paint) {
                graphics2D.setPaint((Paint)gdiObject.obj);
            } else {
                graphics2D.setPaint(this.getPaint((byte[])gdiObject.obj));
            }
            n = -1;
        }
    }

    private Paint getStoredPaint(WMFRecordStore wMFRecordStore, int n) {
        if (n >= 0) {
            GdiObject gdiObject = wMFRecordStore.getObject(n);
            if (gdiObject.obj instanceof Paint) {
                return (Paint)gdiObject.obj;
            }
            return this.getPaint((byte[])gdiObject.obj);
        }
        return null;
    }

    private void paint(int n, int n2, Shape shape, Graphics2D graphics2D) {
        Paint paint;
        if (n >= 0) {
            paint = this.getStoredPaint(this.currentStore, n);
            if (!this.firstEffectivePaint || !paint.equals(Color.white)) {
                this.setBrushPaint(this.currentStore, graphics2D, n);
                graphics2D.fill(shape);
                this.firstEffectivePaint = false;
            }
        }
        if (n2 >= 0) {
            paint = this.getStoredPaint(this.currentStore, n2);
            if (!this.firstEffectivePaint || !paint.equals(Color.white)) {
                this.setPenColor(this.currentStore, graphics2D, n2);
                graphics2D.draw(shape);
                this.firstEffectivePaint = false;
            }
        }
    }

    private void paintWithPen(int n, Shape shape, Graphics2D graphics2D) {
        if (n >= 0) {
            Paint paint = this.getStoredPaint(this.currentStore, n);
            if (!this.firstEffectivePaint || !paint.equals(Color.white)) {
                this.setPenColor(this.currentStore, graphics2D, n);
                graphics2D.draw(shape);
                this.firstEffectivePaint = false;
            }
        }
    }

    private float getVerticalAlignmentValue(TextLayout textLayout, int n) {
        if (n == 8) {
            return -textLayout.getDescent();
        }
        if (n == 0) {
            return textLayout.getAscent();
        }
        return 0.0f;
    }

    @Override
    public WMFRecordStore getRecordStore() {
        return this.currentStore;
    }
}

