/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.lock.Lock;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;

public class Status {
    private SVNURL myURL;
    private File myFile;
    @NotNull
    private NodeKind myKind;
    @NotNull
    private SVNRevision myRevision;
    @NotNull
    private SVNRevision myCommittedRevision;
    private StatusType myContentsStatus;
    private StatusType myPropertiesStatus;
    private StatusType myRemoteContentsStatus;
    private StatusType myRemoteNodeStatus;
    private StatusType myRemotePropertiesStatus;
    private boolean myIsLocked;
    private boolean myIsCopied;
    private boolean myIsSwitched;
    private SVNURL myCopyFromURL;
    @Nullable
    private Lock myRemoteLock;
    @Nullable
    private Lock myLocalLock;
    private SVNRevision myRemoteRevision;
    private String myChangelistName;
    @Nullable
    private TreeConflictDescription myTreeConflict;
    private boolean myIsConflicted;
    private StatusType myNodeStatus;
    private SVNURL myRepositoryRootURL;

    @Nullable
    public static Status create(@Nullable SVNStatus status) throws SvnBindException {
        Status result = null;
        if (status != null) {
            result = new Status(status.getURL(), status.getFile(), NodeKind.from(status.getKind()), status.getRevision(), status.getCommittedRevision(), StatusType.from(status.getContentsStatus()), StatusType.from(status.getPropertiesStatus()), StatusType.from(status.getRemoteContentsStatus()), StatusType.from(status.getRemotePropertiesStatus()), status.isLocked(), status.isCopied(), status.isSwitched(), status.getCopyFromURL() != null ? SvnUtil.createUrl(status.getCopyFromURL()) : null, Lock.create(status.getRemoteLock()), Lock.create(status.getLocalLock()), status.getChangelistName(), TreeConflictDescription.create(status.getTreeConflict()));
            result.setIsConflicted(status.isConflicted());
            result.setNodeStatus(StatusType.from(status.getNodeStatus()));
            result.setRemoteNodeStatus(StatusType.from(status.getRemoteNodeStatus()));
            result.setRemoteRevision(status.getRemoteRevision());
            result.setRepositoryRootURL(status.getRepositoryRootURL());
        }
        return result;
    }

    public Status(SVNURL url, File file, @NotNull NodeKind kind, @Nullable SVNRevision revision, @Nullable SVNRevision committedRevision, StatusType contentsStatus, StatusType propertiesStatus, StatusType remoteContentsStatus, StatusType remotePropertiesStatus, boolean isLocked, boolean isCopied, boolean isSwitched, SVNURL copyFromURL, @Nullable Lock remoteLock, @Nullable Lock localLock, String changelistName, @Nullable TreeConflictDescription treeConflict) {
        if (kind == null) {
            Status.$$$reportNull$$$0(0);
        }
        this.myURL = url;
        this.myFile = file;
        this.myKind = kind;
        this.myRevision = revision == null ? SVNRevision.UNDEFINED : revision;
        this.myCommittedRevision = committedRevision == null ? SVNRevision.UNDEFINED : committedRevision;
        this.myContentsStatus = contentsStatus == null ? StatusType.STATUS_NONE : contentsStatus;
        this.myPropertiesStatus = propertiesStatus == null ? StatusType.STATUS_NONE : propertiesStatus;
        this.myRemoteContentsStatus = remoteContentsStatus == null ? StatusType.STATUS_NONE : remoteContentsStatus;
        this.myRemotePropertiesStatus = remotePropertiesStatus == null ? StatusType.STATUS_NONE : remotePropertiesStatus;
        this.myRemoteNodeStatus = StatusType.STATUS_NONE;
        this.myIsLocked = isLocked;
        this.myIsCopied = isCopied;
        this.myIsSwitched = isSwitched;
        this.myCopyFromURL = copyFromURL;
        this.myRemoteLock = remoteLock;
        this.myLocalLock = localLock;
        this.myChangelistName = changelistName;
        this.myTreeConflict = treeConflict;
        this.myRemoteRevision = SVNRevision.UNDEFINED;
    }

    public Status() {
        this.setRevision(SVNRevision.UNDEFINED);
        this.myRemoteRevision = SVNRevision.UNDEFINED;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public File getFile() {
        return this.myFile;
    }

    @NotNull
    public NodeKind getKind() {
        NodeKind nodeKind = this.myKind;
        if (nodeKind == null) {
            Status.$$$reportNull$$$0(1);
        }
        return nodeKind;
    }

    @NotNull
    public SVNRevision getRevision() {
        SVNRevision sVNRevision = this.myRevision;
        if (sVNRevision == null) {
            Status.$$$reportNull$$$0(2);
        }
        return sVNRevision;
    }

    @NotNull
    public SVNRevision getCommittedRevision() {
        SVNRevision sVNRevision = this.myCommittedRevision;
        if (sVNRevision == null) {
            Status.$$$reportNull$$$0(3);
        }
        return sVNRevision;
    }

    public StatusType getContentsStatus() {
        return this.myContentsStatus;
    }

    public StatusType getPropertiesStatus() {
        return this.myPropertiesStatus;
    }

    public StatusType getRemoteContentsStatus() {
        return this.myRemoteContentsStatus;
    }

    public StatusType getRemotePropertiesStatus() {
        return this.myRemotePropertiesStatus;
    }

    public boolean is(@NotNull StatusType type) {
        if (type == null) {
            Status.$$$reportNull$$$0(4);
        }
        return type.equals((Object)this.getNodeStatus()) || type.equals((Object)this.getContentsStatus());
    }

    public boolean is(StatusType ... types) {
        if (types == null) {
            Status.$$$reportNull$$$0(5);
        }
        return ContainerUtil.or((Object[])types, type -> this.is((StatusType)((Object)type)));
    }

    public boolean isProperty(@NotNull StatusType type) {
        if (type == null) {
            Status.$$$reportNull$$$0(6);
        }
        return type.equals((Object)this.getPropertiesStatus());
    }

    public boolean isProperty(StatusType ... types) {
        if (types == null) {
            Status.$$$reportNull$$$0(7);
        }
        return ContainerUtil.or((Object[])types, type -> this.isProperty((StatusType)((Object)type)));
    }

    public boolean isLocked() {
        return this.myIsLocked;
    }

    public boolean isCopied() {
        return this.myIsCopied;
    }

    public boolean isSwitched() {
        return this.myIsSwitched;
    }

    @Nullable
    public SVNURL getCopyFromURL() {
        return this.myCopyFromURL;
    }

    @Nullable
    public Lock getRemoteLock() {
        return this.myRemoteLock;
    }

    @Nullable
    public Lock getLocalLock() {
        return this.myLocalLock;
    }

    public SVNRevision getRemoteRevision() {
        return this.myRemoteRevision;
    }

    public String getChangelistName() {
        return this.myChangelistName;
    }

    @Nullable
    public TreeConflictDescription getTreeConflict() {
        return this.myTreeConflict;
    }

    public boolean isConflicted() {
        return this.myIsConflicted;
    }

    public StatusType getRemoteNodeStatus() {
        return this.myRemoteNodeStatus;
    }

    public StatusType getNodeStatus() {
        if (this.myNodeStatus == null) {
            return this.myContentsStatus;
        }
        return this.myNodeStatus;
    }

    public SVNURL getRepositoryRootURL() {
        return this.myRepositoryRootURL;
    }

    public void setURL(SVNURL uRL) {
        this.myURL = uRL;
    }

    public void setFile(File file) {
        this.myFile = file;
    }

    public void setKind(@NotNull NodeKind kind) {
        if (kind == null) {
            Status.$$$reportNull$$$0(8);
        }
        this.myKind = kind;
    }

    public void setRevision(@NotNull SVNRevision revision) {
        if (revision == null) {
            Status.$$$reportNull$$$0(9);
        }
        this.myRevision = revision;
    }

    public void setCommittedRevision(@NotNull SVNRevision committedRevision) {
        if (committedRevision == null) {
            Status.$$$reportNull$$$0(10);
        }
        this.myCommittedRevision = committedRevision;
    }

    public void setContentsStatus(StatusType statusType) {
        this.myContentsStatus = statusType;
    }

    public void setPropertiesStatus(StatusType propertiesStatus) {
        this.myPropertiesStatus = propertiesStatus;
    }

    public void setRemoteContentsStatus(StatusType remoteContentsStatus) {
        this.myRemoteContentsStatus = remoteContentsStatus;
    }

    public void setRemotePropertiesStatus(StatusType remotePropertiesStatus) {
        this.myRemotePropertiesStatus = remotePropertiesStatus;
    }

    public void setIsLocked(boolean isLocked) {
        this.myIsLocked = isLocked;
    }

    public void setIsCopied(boolean isCopied) {
        this.myIsCopied = isCopied;
    }

    public void setIsSwitched(boolean isSwitched) {
        this.myIsSwitched = isSwitched;
    }

    public void setRemoteLock(@Nullable Lock remoteLock) {
        this.myRemoteLock = remoteLock;
    }

    public void setLocalLock(@Nullable Lock localLock) {
        this.myLocalLock = localLock;
    }

    public void setChangelistName(String changelistName) {
        this.myChangelistName = changelistName;
    }

    public void setIsConflicted(boolean isConflicted) {
        this.myIsConflicted = isConflicted;
    }

    public void setRemoteNodeStatus(StatusType remoteNodeStatus) {
        this.myRemoteNodeStatus = remoteNodeStatus;
    }

    public void setNodeStatus(StatusType nodeStatus) {
        this.myNodeStatus = nodeStatus;
    }

    public void setRepositoryRootURL(SVNURL repositoryRootURL) {
        this.myRepositoryRootURL = repositoryRootURL;
    }

    public void setRemoteRevision(SVNRevision remoteRevision) {
        this.myRemoteRevision = remoteRevision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/status/Status";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "committedRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/status/Status";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevision";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommittedRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setKind";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setRevision";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCommittedRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

