/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.ByKeySelectedSearcher;
import org.jetbrains.idea.svn.dialogs.FileByKeySelectedSearcher;
import org.jetbrains.idea.svn.dialogs.FolderByKeySelectedSearcher;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeModel;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeRootNode;
import org.jetbrains.idea.svn.dialogs.SimpleTextNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class RepositoryTreeNode
implements TreeNode,
Disposable {
    private TreeNode myParentNode;
    @NotNull
    private final List<TreeNode> myChildren;
    private final RepositoryTreeModel myModel;
    private final SVNURL myURL;
    private final Object myUserObject;
    @NotNull
    private final NodeLoadState myLoadState;
    private NodeLoadState myChildrenLoadState;

    public RepositoryTreeNode(RepositoryTreeModel model, TreeNode parentNode, @NotNull SVNURL url, Object userObject, @NotNull NodeLoadState state) {
        if (url == null) {
            RepositoryTreeNode.$$$reportNull$$$0(0);
        }
        if (state == null) {
            RepositoryTreeNode.$$$reportNull$$$0(1);
        }
        this.myParentNode = parentNode;
        this.myURL = url;
        this.myModel = model;
        this.myUserObject = userObject;
        this.myLoadState = state;
        this.myChildren = ContainerUtil.newArrayList();
        this.myChildrenLoadState = NodeLoadState.EMPTY;
    }

    public RepositoryTreeNode(RepositoryTreeModel model, TreeNode parentNode, @NotNull SVNURL url, Object userObject) {
        if (url == null) {
            RepositoryTreeNode.$$$reportNull$$$0(2);
        }
        this(model, parentNode, url, userObject, NodeLoadState.REFRESHED);
    }

    public Object getUserObject() {
        return this.myUserObject;
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    public Enumeration children() {
        return Collections.enumeration(this.getChildren());
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.getChildren().get(childIndex);
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    @Override
    public boolean isLeaf() {
        return this.myUserObject instanceof DirectoryEntry && ((DirectoryEntry)this.myUserObject).isFile();
    }

    @Override
    public TreeNode getParent() {
        return this.myParentNode;
    }

    public void reload(boolean removeCurrentChildren) {
        this.reload(removeCurrentChildren ? this.myModel.getSelectionKeepingExpander() : this.myModel.getLazyLoadingExpander(), removeCurrentChildren);
    }

    @Nullable
    public TreeNode getNextChildByKey(String key, boolean isFolder) {
        ByKeySelectedSearcher searcher = isFolder ? new FolderByKeySelectedSearcher(key, this.myChildren) : new FileByKeySelectedSearcher(key, this.myChildren);
        return searcher.getNextSelectedByKey();
    }

    public String toString() {
        if (this.myParentNode instanceof RepositoryTreeRootNode) {
            return this.myURL.toString();
        }
        return SVNPathUtil.tail((String)this.myURL.getPath());
    }

    public void reload(@NotNull Expander expander, boolean removeCurrentChildren) {
        if (expander == null) {
            RepositoryTreeNode.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (removeCurrentChildren || NodeLoadState.EMPTY.equals((Object)this.myChildrenLoadState)) {
            this.initChildren();
        }
        this.myModel.getCacheLoader().load(this, expander);
    }

    private void initChildren() {
        this.myChildren.clear();
        this.myChildren.add(new SimpleTextNode(CommonBundle.getLoadingTreeNodeText()));
        this.myChildrenLoadState = NodeLoadState.LOADING;
    }

    private List getChildren() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (NodeLoadState.EMPTY.equals((Object)this.myChildrenLoadState)) {
            this.initChildren();
            this.myModel.getCacheLoader().load(this, this.myModel.getLazyLoadingExpander());
        }
        return this.myChildren;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    @Nullable
    public DirectoryEntry getSVNDirEntry() {
        return this.myUserObject instanceof DirectoryEntry ? (DirectoryEntry)this.myUserObject : null;
    }

    public void dispose() {
    }

    public TreeNode[] getSelfPath() {
        return this.myModel.getPathToRoot(this);
    }

    public boolean isRepositoryRoot() {
        return !(this.myUserObject instanceof DirectoryEntry);
    }

    @NotNull
    public List<TreeNode> getAllAlreadyLoadedChildren() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.myChildren);
        if (arrayList == null) {
            RepositoryTreeNode.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public List<RepositoryTreeNode> getAlreadyLoadedChildren() {
        List list = ContainerUtil.collect(this.myChildren.iterator(), (FilteringIterator.InstanceOf)FilteringIterator.instanceOf(RepositoryTreeNode.class));
        if (list == null) {
            RepositoryTreeNode.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean isDisposed() {
        return this.myModel.isDisposed();
    }

    public void setChildren(@NotNull List<DirectoryEntry> children, @NotNull NodeLoadState state) {
        if (children == null) {
            RepositoryTreeNode.$$$reportNull$$$0(6);
        }
        if (state == null) {
            RepositoryTreeNode.$$$reportNull$$$0(7);
        }
        ArrayList<RepositoryTreeNode> nodes = new ArrayList<RepositoryTreeNode>();
        for (DirectoryEntry entry : children) {
            if (!this.myModel.isShowFiles() && !entry.isDirectory()) continue;
            nodes.add(new RepositoryTreeNode(this.myModel, this, entry.getUrl(), entry, state));
        }
        this.myChildrenLoadState = state;
        this.myChildren.clear();
        this.myChildren.addAll(nodes);
        this.myModel.reload(this);
    }

    public void setParentNode(TreeNode parentNode) {
        this.myParentNode = parentNode;
    }

    public void setAlienChildren(List<TreeNode> children, NodeLoadState oldState) {
        this.myChildren.clear();
        for (TreeNode child : children) {
            if (child instanceof RepositoryTreeNode) {
                ((RepositoryTreeNode)child).setParentNode(this);
                this.myChildren.add(child);
                this.myChildrenLoadState = oldState;
                continue;
            }
            if (!(child instanceof SimpleTextNode)) continue;
            SimpleTextNode node = (SimpleTextNode)child;
            this.myChildren.add(new SimpleTextNode(node.getText(), node.isError()));
            this.myChildrenLoadState = oldState;
        }
        this.myModel.reload(this);
    }

    public void setErrorNode(@NotNull String text) {
        if (text == null) {
            RepositoryTreeNode.$$$reportNull$$$0(8);
        }
        this.myChildren.clear();
        this.myChildren.add(new SimpleTextNode(text, true));
        this.myChildrenLoadState = NodeLoadState.ERROR;
        this.myModel.reload(this);
    }

    public SvnVcs getVcs() {
        return this.myModel.getVCS();
    }

    public boolean isCached() {
        return NodeLoadState.CACHED.equals((Object)this.myLoadState);
    }

    @Nullable
    public RepositoryTreeNode getNodeWithSamePathUnderModelRoot() {
        return this.myModel.findByUrl(this);
    }

    public NodeLoadState getChildrenLoadState() {
        return this.myChildrenLoadState;
    }

    public void doOnSubtree(@NotNull NotNullFunction<RepositoryTreeNode, Object> function) {
        if (function == null) {
            RepositoryTreeNode.$$$reportNull$$$0(9);
        }
        new SubTreeWalker(this, function).execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expander";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/RepositoryTreeNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/RepositoryTreeNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAlreadyLoadedChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlreadyLoadedChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reload";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setErrorNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doOnSubtree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SubTreeWalker {
        @NotNull
        private final RepositoryTreeNode myNode;
        @NotNull
        private final NotNullFunction<RepositoryTreeNode, Object> myFunction;

        private SubTreeWalker(@NotNull RepositoryTreeNode node, @NotNull NotNullFunction<RepositoryTreeNode, Object> function) {
            if (node == null) {
                SubTreeWalker.$$$reportNull$$$0(0);
            }
            if (function == null) {
                SubTreeWalker.$$$reportNull$$$0(1);
            }
            this.myNode = node;
            this.myFunction = function;
        }

        public void execute() {
            this.executeImpl(this.myNode);
        }

        private void executeImpl(RepositoryTreeNode node) {
            this.myFunction.fun((Object)node);
            for (RepositoryTreeNode child : node.getAlreadyLoadedChildren()) {
                this.myFunction.fun((Object)child);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "function";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/svn/dialogs/RepositoryTreeNode$SubTreeWalker";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

