/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnNativeCallsTranslator;

public class NativeLogReader {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.NativeLogReader");
    private static final MultiMap<Thread, CallInfo> ourCallLog = new MultiMap<Thread, CallInfo>(){

        @NotNull
        protected Collection<CallInfo> createCollection() {
            ArrayList<CallInfo> arrayList = new ArrayList<CallInfo>(2);
            if (arrayList == null) {
                1.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/NativeLogReader$1", "createCollection"));
        }
    };
    private static final Set<Thread> ourTrackedThreads = Collections.synchronizedSet(new HashSet());
    private static final Object ourLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putInfo(@NotNull CallInfo callInfo) {
        Thread key;
        if (callInfo == null) {
            NativeLogReader.$$$reportNull$$$0(0);
        }
        if (ourTrackedThreads.size() > 1000) {
            for (CallInfo info : ourCallLog.values()) {
                LOG.info(SvnNativeCallsTranslator.defaultMessage(info));
            }
            LOG.warn("Too many cached Subversion native calls. Log cleared.");
            ourTrackedThreads.clear();
        }
        if (ourTrackedThreads.contains(key = Thread.currentThread())) {
            Object object = ourLock;
            synchronized (object) {
                ourCallLog.putValue((Object)key, (Object)callInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Thread key = Thread.currentThread();
        if (ourTrackedThreads.contains(key)) {
            Object object = ourLock;
            synchronized (object) {
                ourCallLog.remove((Object)key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CallInfo> getLogged() {
        Thread key = Thread.currentThread();
        if (ourTrackedThreads.contains(key)) {
            Object object = ourLock;
            synchronized (object) {
                return (List)ourCallLog.get((Object)key);
            }
        }
        return Collections.emptyList();
    }

    public static void startTracking() {
        ourTrackedThreads.add(Thread.currentThread());
    }

    public static void endTracking() {
        ourTrackedThreads.remove(Thread.currentThread());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/idea/svn/NativeLogReader", "putInfo"));
    }

    public static class CallInfo {
        private final String myFunctionName;
        private final int myResultCode;
        private final String myStrResultCode;

        public CallInfo(@NotNull String functionName, int resultCode) {
            if (functionName == null) {
                CallInfo.$$$reportNull$$$0(0);
            }
            this.myFunctionName = functionName;
            this.myResultCode = resultCode;
            this.myStrResultCode = String.valueOf(resultCode);
        }

        public CallInfo(@NotNull String functionName, @NotNull String resultCode) {
            if (functionName == null) {
                CallInfo.$$$reportNull$$$0(1);
            }
            if (resultCode == null) {
                CallInfo.$$$reportNull$$$0(2);
            }
            this.myFunctionName = functionName;
            this.myResultCode = 0;
            this.myStrResultCode = resultCode;
        }

        public String getFunctionName() {
            return this.myFunctionName;
        }

        public int getResultCode() {
            return this.myResultCode;
        }

        public String getStrResultCode() {
            return this.myStrResultCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallInfo info = (CallInfo)o;
            if (this.myResultCode != info.myResultCode) {
                return false;
            }
            if (!this.myFunctionName.equals(info.myFunctionName)) {
                return false;
            }
            return this.myStrResultCode.equals(info.myStrResultCode);
        }

        public int hashCode() {
            int result = this.myFunctionName.hashCode();
            result = 31 * result + this.myResultCode;
            result = 31 * result + this.myStrResultCode.hashCode();
            return result;
        }

        public String toString() {
            return "CallInfo{myFunctionName='" + this.myFunctionName + '\'' + ", myResultCode=" + this.myResultCode + ", myStrResultCode='" + this.myStrResultCode + '\'' + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "functionName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultCode";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/svn/NativeLogReader$CallInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

