/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import icons.PythonIcons;
import org.jetbrains.annotations.NotNull;

public class IpnbConvertFromPythonAction
extends AnAction {
    public IpnbConvertFromPythonAction() {
        super(PythonIcons.Python.IpythonNotebook);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            IpnbConvertFromPythonAction.$$$reportNull$$$0(0);
        }
        DataContext context = event.getDataContext();
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        IpnbConvertFromPythonAction.convertFromPythonScript(virtualFile, project);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(true);
        e.getPresentation().setVisible(true);
        DataContext context = e.getDataContext();
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (!(psiFile instanceof PyFile)) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setVisible(false);
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (virtualFile == null || project == null) {
            e.getPresentation().setEnabled(false);
        }
    }

    private static void convertFromPythonScript(VirtualFile virtualFile, Project project) {
        Module module = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(virtualFile);
        if (module == null) {
            return;
        }
        Sdk sdk = PythonSdkType.findPythonSdk((Module)module);
        if (sdk == null) {
            return;
        }
        String homePath = sdk.getHomePath();
        if (homePath == null) {
            return;
        }
        PySdkUtil.getProcessOutput((String)virtualFile.getParent().getPath(), (String[])new String[]{homePath, PythonHelpersLocator.getHelperPath((String)"py2ipnb_converter.py"), virtualFile.getPath()});
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile.getParent()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ipnb/editor/actions/IpnbConvertFromPythonAction", "actionPerformed"));
    }
}

