/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;
import org.jetbrains.plugins.github.api.data.GithubUser;

@RestModel
public class GithubUserDetailed
extends GithubUser {
    private String name;
    private String email;
    private String company;
    private String location;
    private String type;
    private Integer publicRepos;
    private Integer publicGists;
    private Integer totalPrivateRepos;
    private Integer ownedPrivateRepos;
    private Integer privateGists;
    private Long diskUsage;
    private UserPlan plan;

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public boolean canCreatePrivateRepo() {
        return this.plan == null || this.ownedPrivateRepos == null || this.plan.getPrivateRepos() > (long)this.ownedPrivateRepos.intValue();
    }

    @RestModel
    public static class UserPlan {
        private String name;
        private Long space;
        private Long collaborators;
        @Mandatory
        private Long privateRepos;

        public long getPrivateRepos() {
            return this.privateRepos;
        }
    }
}

