/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutBuilderImpl;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import java.awt.Component;
import java.awt.Container;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.IcsSettingsKt;
import org.jetbrains.settingsRepository.ReadOnlySourcesEditorKt;
import org.jetbrains.settingsRepository.RepositoryListEditorKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/settingsRepository/IcsConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "Lcom/intellij/openapi/Disposable;", "()V", "autoSync", "Ljavax/swing/JCheckBox;", "editors", "", "icsManager", "Lorg/jetbrains/settingsRepository/IcsManager;", "apply", "", "settings", "dispose", "getComponent", "Ljavax/swing/JPanel;", "isModified", "", "reset", "settings-repository"})
public final class IcsConfigurableUi
implements ConfigurableUi<IcsSettings>,
Disposable {
    private final IcsManager icsManager;
    private final List<ConfigurableUi<IcsSettings>> editors;
    private final JCheckBox autoSync;

    public void dispose() {
        this.icsManager.getAutoSyncManager$settings_repository().setEnabled(true);
    }

    public void reset(@NotNull IcsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.icsManager.getAutoSyncManager$settings_repository().setEnabled(false);
        this.autoSync.setSelected(settings.getAutoSync());
        Iterable $receiver$iv = this.editors;
        for (Object element$iv : $receiver$iv) {
            ConfigurableUi it = (ConfigurableUi)element$iv;
            it.reset((Object)settings);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified(@NotNull IcsSettings settings) {
        Object element$iv;
        ConfigurableUi it;
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        if (this.autoSync.isSelected() != settings.getAutoSync()) return true;
        Iterable $receiver$iv = this.editors;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!(it = (ConfigurableUi)(element$iv = iterator.next())).isModified((Object)settings));
        return true;
    }

    public void apply(@NotNull IcsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        settings.setAutoSync(this.autoSync.isSelected());
        Iterable $receiver$iv = this.editors;
        for (Object element$iv : $receiver$iv) {
            ConfigurableUi it = (ConfigurableUi)element$iv;
            if (!it.isModified((Object)settings)) continue;
            it.apply((Object)settings);
        }
        IcsSettingsKt.saveSettings(settings, this.icsManager.getSettingsFile());
    }

    @NotNull
    public JPanel getComponent() {
        Row row$iv$iv;
        LayoutBuilder builder$iv$iv;
        LayoutBuilder $receiver$iv;
        LCFlags[] constraints$iv$iv = new LCFlags[]{LCFlags.noGrid, LCFlags.flowY, LCFlags.fillX};
        String title$iv$iv = null;
        LayoutBuilder this_$iv$iv = $receiver$iv = (builder$iv$iv = LayoutImplKt.createLayoutBuilder());
        JLabel label$iv$iv = null;
        boolean separated$iv$iv = false;
        Row $receiver = row$iv$iv = LayoutBuilderImpl.DefaultImpls.newRow$default((LayoutBuilderImpl)this_$iv$iv.get$(), (JLabel)label$iv$iv, (ButtonGroup)this_$iv$iv.getButtonGroup(), (boolean)separated$iv$iv, (boolean)false, (int)8, null);
        Row.invoke$default((Row)$receiver, (JComponent)this.editors.get(0).getComponent(), (CCFlags[])new CCFlags[0], (int)0, null, (int)6, null);
        Row.invoke$default((Row)$receiver, (JComponent)this.autoSync, (CCFlags[])new CCFlags[0], (int)0, null, (int)6, null);
        $receiver.hint("Use VCS -> Sync Settings to sync when you want");
        JComponent jComponent = this.editors.get(1).getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"editors.get(1).component");
        $receiver.panel("Read-only Sources", (Component)jComponent, new CCFlags[0]);
        JPanel panel$iv$iv = ComponentsKt.Panel((String)title$iv$iv, null);
        builder$iv$iv.get$().build((Container)panel$iv$iv, constraints$iv$iv);
        return panel$iv$iv;
    }

    public IcsConfigurableUi() {
        IcsManager icsManager2;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Path path = Paths.get(PathManager.getConfigPath(), new String[0]).resolve("settingsRepository");
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(PathManager.ge\u2026lve(\"settingsRepository\")");
            icsManager2 = new IcsManager(path, null, 2, null);
        } else {
            icsManager2 = IcsManagerKt.getIcsManager();
        }
        this.icsManager = icsManager2;
        this.editors = CollectionsKt.listOf((Object[])new ConfigurableUi[]{RepositoryListEditorKt.createRepositoryListEditor(this.icsManager), ReadOnlySourcesEditorKt.createReadOnlySourcesEditor()});
        this.autoSync = new JCheckBox("Auto Sync");
    }
}

