// ----------------------------------------------------------------------------
// markItUp!
// ----------------------------------------------------------------------------
// Copyright (C) 2008 Jay Salvat
// http://markitup.jaysalvat.com/
// ----------------------------------------------------------------------------
// Texy!
// http://texy.info
// ----------------------------------------------------------------------------
var myTexySettings = {
    nameSpace: "texy", // Useful to prevent multi-instances CSS conflict
    previewParserPath:   "./?rt=texy/preview",
    onShiftEnter: {keepDefault:false, replaceWith:'\n\n'},
    onTab: {keepDefault:false, replaceWith:'    '},
    markupSet: [
        {name:'Heading 1', key:'1', openWith:'======= ', closeWith:' =======', placeHolder:'Your title here...', className:'h1' },
        {name:'Heading 2', key:'2', openWith:'====== ', closeWith:'======', placeHolder:'Your title here...', className:'h2' },
        {name:'Heading 3', key:'3', openWith:'===== ', closeWith:' =====', placeHolder:'Your title here...', className:'h3' },
        {name:'Heading 4', key:'4', openWith:'==== ', closeWith:' ====', placeHolder:'Your title here...', className:'h4' },
        {name:'Heading 5', key:'5', openWith:'=== ', closeWith:' ===', placeHolder:'Your title here...', className:'h5' },
        {name:'Heading 6', key:'6', openWith:'== ', closeWith:' ==', placeHolder:'Your title here...', className:'h6' },
        {separator:'---------------' },
	{name:'Bold', key:'B', closeWith:'**', openWith:'**', className:'bold', placeHolder:'Your text here...'}, 
        {name:'Italic', key:'I', closeWith:'*', openWith:'*', className:'italic', placeHolder:'Your text here...'},
	{name:'Stroke through', openWith:'--', closeWith:'--', className:'stroke', dropMenu:[
	    {name:'Superscript', openWith:'^^', closeWith:'^^', className:'sup'},
	    {name:'Subscript', openWith:'__', closeWith:'__', className:'sub'}
	]},
	{separator:'---------------' },
	{name:'Colors', className:'color', dropMenu:[
	    {name:'Black', closeWith:' .{color:Black}', className:'col1-1'},
	    {name:'Silver', closeWith:' .{color:Silver}', className:'col1-2'},
	    {name:'Gray', closeWith:' .{color:Gray}', className:'col1-3'},
	    {name:'White', closeWith:' .{color:White}', className:'col1-4'},
	    {name:'Maroon', closeWith:' .{color:Maroon}', className:'col1-5'},
	    {name:'Red', closeWith:' .{color:Red}', className:'col2-1'},
	    {name:'Purple', closeWith:' .{color:Purple}', className:'col2-2'},
	    {name:'Fuchsia', closeWith:' .{color:Fuchsia}', className:'col2-3'},
	    {name:'Green', closeWith:' .{color:Green}', className:'col2-4'},
	    {name:'Lime', closeWith:' .{color:Lime}', className:'col2-5'},
	    {name:'Olive', closeWith:' .{color:Olive}', className:'col3-1'},
	    {name:'Yellow', closeWith:' .{color:Yellow}', className:'col3-2'},
	    {name:'Navy', closeWith:' .{color:Navy}', className:'col3-3'},
	    {name:'Blue', closeWith:' .{color:Blue}', className:'col3-4'},
	    {name:'Teal', closeWith:' .{color:Teal}', className:'col3-5'},
	    {name:'Cyan', closeWith:' .{color:Cyan}', className:'col4-1'},
	    {name:'Salmon', closeWith:' .{color:Salmon}', className:'col4-2'},
	    {name:'Crimson', closeWith:' .{color:Crimson}', className:'col4-3'},
	    {name:'FireBrick', closeWith:' .{color:FireBrick}', className:'col4-4'},
	    {name:'Pink', closeWith:' .{color:Pink}', className:'col4-5'},
	    {name:'DeepPink', closeWith:' .{color:DeepPink}', className:'col5-1'},
	    {name:'Tomato', closeWith:' .{color:Tomato}', className:'col5-2'},
	    {name:'OrangeRed', closeWith:' .{color:OrangeRed}', className:'col5-3'},
	    {name:'Orchid', closeWith:' .{color:Orchid}', className:'col5-4'},
	    {name:'Amethyst', closeWith:' .{color:Amethyst}', className:'col5-5'},
	    {name:'Indigo', closeWith:' .{color:Indigo}', className:'col6-1'},
	    {name:'LimeGreen', closeWith:' .{color:LimeGreen}', className:'col6-2'},
	    {name:'LightGreen', closeWith:' .{color:LightGreen}', className:'col6-3'},
	    {name:'MediumSeaGreen', closeWith:' .{color:MediumSeaGreen}', className:'col6-4'},
	    {name:'SeaGreen', closeWith:' .{color:SeaGreen}', className:'col6-5'},
	    {name:'ForestGreen', closeWith:' .{color:ForestGreen}', className:'col7-1'},
	    {name:'DarkSeaGreen', closeWith:' .{color:DarkSeaGreen}', className:'col7-2'},
	    {name:'Turquoise', closeWith:' .{color:Turquoise}', className:'col7-3'},
	    {name:'SteelBlue', closeWith:' .{color:SteelBlue}', className:'col7-4'},
	    {name:'DeepSkyBlue', closeWith:' .{color:DeepSkyBlue}', className:'col7-5'},
	    {name:'DodgerBlue', closeWith:' .{color:DodgerBlue}', className:'col8-1'},
	    {name:'DarkBlue', closeWith:' .{color:DarkBlue}', className:'col8-2'},
	    {name:'Wheat', closeWith:' .{color:Wheat}', className:'col8-3'},
	    {name:'Peru', closeWith:' .{color:Peru}', className:'col8-4'},
	    {name:'Beige', closeWith:' .{color:Beige}', className:'col8-5'},
	    {name:'LightGrey', closeWith:' .{color:LightGrey}', className:'col9-1'},
	    {name:'DarkGray', closeWith:' .{color:DarkGray}', className:'col9-2'},
	    {name:'DimGray', closeWith:' .{color:DimGray}', className:'col9-3'}
	]},
	{separator:'---------------' },
	{name:'Center', openWith:'.<>\n', className:'center', dropMenu:[
	    {name:'Left', openWith:'.<\n', className:'left'},
	    {name:'Right', openWith:'.>\n', className:'right'},
	    {name:'Justify', openWith:'.=\n', className:'justify'}
	]},
	{separator:'---------------' },
	{name:'Bulleted list', openWith:'- ', multiline:true, className:'list-bullet'}, 
        {name:'Numeric list', openWith:function(markItUp) {return markItUp.line + ') ';}, multiline:true, className:'list-numeric'}, 
        {separator:'---------------' },
        {name:'Picture', key:'P', openWith:'[* ', closeWith:' .([![Alternative text]!]t) *]', placeHolder:'[![Source:!:http://]!]',className:'image'}, 
        {name:'Link', key:'L', openWith:'"', closeWith:'":[[![Link:!:http://]!]]', placeHolder:'[![Title]!]', className:'link' },     
	{separator:'---------------' },
        {name:'Quotes', openWith:'> ', multiline:true, className:'quotes'}, 
        {name:'Code', openWith:'/---code [![Language:!:html]!]\n', closeWith:'\n\\---', className:'code', dropMenu:[
	    {name:'HTML', openWith:'/---code html\n', closeWith:'\n\\---', className:'codeHtml'},
	    {name:'CSS', openWith:'/---code css\n', closeWith:'\n\\---', className:'codeCss'},
	    {name:'JavaScript', openWith:'/---code javascript\n', closeWith:'\n\\---', className:'codeJs'},
	    {name:'PHP', openWith:'/---code php\n', closeWith:'\n\\---', className:'codePhp'},
	    {name:'SQL', openWith:'/---code sql\n', closeWith:'\n\\---', className:'codeSql'}
	]},
	{separator:'---------------' },
	{name:'Table', replaceWith:'|-----------------------------\n|first col|second col|third col\n|-----------------------------\n|    |    |    |\n|    |    |    |', className:'table'},
	{separator:'---------------' },
	{name:'Thematic break', replaceWith:'------------\n', className:'hr'},
	{name:'Div block', openWith:'/---div .[[![Class]!]]\n', closeWith:'\n\\---', placeHolder:'\n  content of div\n', className:'div', dropMenu:[
	    {name:'HTML', openWith:'/---html\n', closeWith:'\n\\---', placeHolder:'', className:'html'},
	    {name:'Text', openWith:'/---text\n', closeWith:'\n\\---', placeHolder:'', className:'text'},
	    {name:'Inline text', openWith:'\'\'', closeWith:'\'\'', className:'notexy'}
	]},
	{separator:'---------------' },
	{name:'Preview', call:'preview', className:'preview' }
    ]
}
