<?php
/**
 * Macro {texy} ... {/texy}
 * Implements the IFilter interface
 * @author Jérôme Brilland
 * @version 2.0
 * @copyright (c) 2019-2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class TexyMacroFilter implements IFilter {

    /**
     * @param Request request Request object
     * @param Response response Response object
     * @access public
     */
    public function execute( Request $request, Response $response, FilterChain $filterchain ) {
        IoC::resolve( 'eventmediator' )->attach( 'before_render', function( $controller, $request, $response ) {
            $latte = IoC::resolve( 'view' )->getLatte();

            $latte->addFilter( 'texy', [IoC::resolve( 'texy' ), 'process'] );
        
            $set = new Latte\Macros\MacroSet( $latte->getCompiler() );
            $set->addMacro( 'texy', function ($node, $writer) {

                return $writer->write('echo IoC::resolve( \'texy\' )->process( %node.word );');
            });
            
            return true;
        });
        
        $filterchain->execute( $request, $response );
    }
}
