<?php
/**
 * SQLschema factory class
 * @author Jerôme Brilland
 * @version 1.0
 * @copyright (c) 2019, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class SQLSchemaFactory {

    /**
     * @param string type
     * @access public
     * @static
     */
    public static function create( $type ) {
        switch( $type ) {
        case 'mysql':
            return new MySQLSchema();
            break;
        case 'pgsql':
            return new PostgreSQLSchema();
        case 'sqlite':
            return new SQLiteSchema();
            break;
        default:
            throw new LogicException( 'Unknow database' );
        }
    }
}
