<?php
/**
 * SQLite factory
 * @author Jérôme Brilland
 * @version 1.1
 * @since 3.0
 * @copyright (c) 2021-2023, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class SQLiteFactory implements IDatabaseFactory {

    protected $options;

    /**
     * Class constructor
     * @param array $options
     * @access public
     */
    public function __construct( array $options ) {
        $this->options = $options;
    }
    
    /**
     * Create a database connection
     * @param array $options
     * @return Medoo the database connection
     * @access public
     */
    public function createConnection() {
        return new \Medoo\Medoo( [
            'type' => 'sqlite',
            'database' => $this->options['database'] ?? $this->options['file']
        ] );
    }

    /**
     * Create a SQLSchema object
     * @param Medoo the database connection
     * @return ISQLSchema the SQLSchema object
     * @access public
     */
    public function createSQLSchema( $database ) {
        return new SQLiteSchema( $database );
    }
}
