<?php

/**
 * Registry class
 * @author Jérôme Brilland
 * @version 2.1
 * @copyright (c) 2009-2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class Registry {

    /**
     * @var string The frameworks name
     * @access private
     * @static
     */
    private static $frameworkName = 'Bluebird version 3.3';

    /**
     * @var array Array that holds all the objects
     * @access private
     * @static
     */
    private static $registry = array();

    /**
     * Add an object instance to the registry
     * @param string key Key
     * @param object object Object
     * @access public
     * @static
     */
    public static function set( $key, $object ) {
        if ( array_key_exists( $key, self::$registry ) ) {
            throw new Exception( $key . ' already exists.' );
        }
        self::$registry[$key] = $object;
    }

    /**
     * Removes an item from the registry
     * @param string key Key
     * @access public
     * @static
     */
    public static function delete( $key ) {
        if ( !array_key_exists( $key, self::$registry ) ) {
            throw new OutOfBoundsException( $key . ' does not exist.' );
        }
        unset( self::$registry[$key] );
    }

    /**
     * Retrieves an object previously added to the registry
     * @param string key Key
     * @return stdclass The object
     * @access public
     * @static
     */
    public static function get( $key ) {
        if ( !array_key_exists( $key, self::$registry ) ) {
            throw new OutOfBoundsException( $key . ' does not exist.' );
        }
        return self::$registry[$key];
    }

    /**
     * Checks to see if the key is currently stored in the registry
     * @param string key Key
     * @access public
     * @static
     */
    public static function exists( $key ) {
        return isset( self::$registry[$key] );
    }

    /**
     * Gets the frameworks name
     * @return string
     * @access public
     * @static
     */
    public static function getFrameworkName() {
        return self::$frameworkName;
    }

}

