<?php
/**
 * PostgreSQL factory
 * @author Jérôme Brilland
 * @version 1.0
 * @since 3.0
 * @copyright (c) 2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class PostgreSQLFactory implements IDatabaseFactory {

    protected $options;

    /**
     * Class constructor
     * @param array $options
     * @access public
     */
    public function __construct( array $options ) {
        $this->options = $options;
    }

    /**
     * Create a database connection
     * @return Medoo the database connection
     * @access public
     */
    public function createConnection() {
        return new \Medoo\Medoo( [
            'database_type' => 'pgsql',
            'database_name' => $this->options['name'],
            'server' => $this->options['server'],
            'username' => $this->options['username'],
            'password' => $this->options['password'],
            'option' => [
                PDO::ATTR_ORACLE_NULLS => PDO::NULL_EMPTY_STRING
            ],
            'command' => [
                sprintf( 'SET search_path TO %s;', $this->options['schema'] ),
                'SET CLIENT_ENCODING TO UTF8'
            ]
        ]);
    }

    /**
     * Create a SQLSchema object
     * @param Medoo the database connection
     * @return ISQLSchema the SQLSchema object
     * @access public
     */
    public function createSQLSchema( $database ) {
        return new PostgreSQLSchema( $database, $this->options['schema'] );
    }
}

