<?php

/*
 * Copyright (C) 2018 jerome
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Description of PHPView
 * Extends the View class
 * Implements the IView interface
 * @author Jérôme Brilland
 * @version 1.0
 * @copyright (c) 2018, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class PHPView implements IView {
    
    /**
     *
     * @var array
     * @access protected 
     */
    protected $data = [];
    
    /**
     * 
     * @param string $directory
     * @access public
     */
    public function addTemplateDirectory( $directory ) {
        set_include_path(get_include_path() . PATH_SEPARATOR . $directory );
    }
    
    /**
     * 
     * @param string $name
     * @param mixed $value
     * @access public
     */
    public function assign( $name, $value ) {
        $this->data[$name] = $value;
    }
    
    /**
     * Render a template
     * @param string $template Template
     * @param array $data
     * @return string Rendered template
     */
    public function render( $template, $data = null ) {
        extract( array_merge( $this->data, $data ) );
        ob_start();
        require( $template );
        $str = ob_get_contents();
        ob_end_clean();
        return $str;
    }
    
}
