<?php
/**
 * PHP file configuration handler class
 * Extends ConfigurationHandler
 * @author Jérôme Brilland
 * @version 1.0
 * @copyright (c) 2019, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class PHPFileConfigurationHandler extends ConfigurationHandler {
    
    /**
     * @var string filename
     * @access private
     */
    private $filename = null;     
    
    /**
     * Class constructor
     * @param string filename
     * @access public
     */
    public function __construct( $filename ) {
        if ( !is_readable( $filename ) ) {
            throw new Exception( $filename . ' cannot be read.' );
        }
        $this->filename = $filename;
    }

    /**
     * @access public
     */
    public function load() {
        $this->values = include( $this->filename );
        return $this;
    }
    
    /**
     * @access public
     */
    public function save() {
        return $this;
    }
    
}
?>
