<?php

/**
 * @author Jérôme Brilland
 * @version 1.0
 * @copyright (c) 2019, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class NullifyBlankObserver implements SplObserver {

    /**
     * Receive update from subject
     * @param SplSubject $subject
     * @param string $key
     * @return boolean
     * @access public
     */
    public function update( SplSubject $subject, $key = null ) {
        if ( 'before_save' == $key ) {
            foreach( $subject->getAttributes() as $key => $value ) {
                if ( is_string( $subject->$key ) && !strlen( $subject->$key ) ) {
                    $subject->$key = null;
                }
            }
        }
        return true;
    }

}

?>
