<?php
/**
 * MySQL UTF-8 workaround
 * Implements the IFilter interface
 * @author Jerôme Brilland
 * @version 2.0
 * @copyright (c) 2010-2021, Jerôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class MySQLUTF8Filter implements IFilter {
	
	/**
	 * @param Request request Request object
	 * @param Response response Response object
	 * @access public
	 */
	public function execute( Request $request, Response $response, FilterChain $filterchain ) {
		$database = IoC::resolve( 'database' );
		$database->query( 'set names utf8' );
		$filterchain->execute( $request, $response );
	}
}

