<?php
/**
 * MySQL factory
 * @author Jérôme Brilland
 * @version 1.0
 * @since 3.0
 * @copyright (c) 2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class MySQLFactory implements IDatabaseFactory {

    protected $options;

    /**
     * Class constructor
     * @param array $options
     * @access public
     */
    public function __construct( array $options ) {
        $this->options = $options;
    }

    /**
     * Create a database connection
     * @return Medoo the database connection
     * @access public
     */
    public function createConnection() {
        return new \Medoo\Medoo( [
            'database_type' => 'mysql',
            'database_name' => $this->options['name'],
            'server' => $this->options['server'],
            'username' => $this->options['username'],
            'password' => $this->options['password'],
            'charset' => 'utf8mb4',
            'option' => [
                PDO::ATTR_ORACLE_NULLS => PDO::NULL_EMPTY_STRING
            ]
        ] );
    }

    /**
     * Create a SQLSchema object
     * @param Medoo the database connection
     * @return ISQLSchema the SQLSchema object
     * @access public
     */
    public function createSQLSchema( $database ) {
        return new MySQLSchema( $database );
    }
}

