<?php

/**
 * Logger class
 * Implements the ILogger interface
 * @author Jerôme Brilland
 * @version 1.1
 * @copyright (c) 2010-2019, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
include( LIB_DIR . 'core' . DS . 'ilogger.class.php' );

class Logger implements ILogger {

    /**
     * @var string Log file name
     * @access private
     */
    private $filename = null;

    /**
     * Class constructor
     * @access public
     */
    public function __construct( $filename ) {
        $this->filename = $filename;
    }

    public function write( $message ) {
        file_put_contents( $this->filename, [PHP_EOL, $message], FILE_APPEND );
    }

}

?>
