<?php
/**
 *
 * @author Jérôme Brilland
 * @version 1.1
 * @copyright (c) 2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class LatteFileLoader extends Latte\Loaders\FileLoader {

    /**
	 * Returns unique identifier for caching.
	 * @return string
	 */
    public function getUniqueId( $name ): string {
        $name = parent::getUniqueId( $name );
        if ( file_exists( $name ) ) {
            return $name;
        }
        throw new RuntimeException( sprintf( 'Template "%s" does not exist.', $name ) );
    }
}
