<?php
/**
 * JSON file configuration handler class
 * Extends ConfigurationHandler
 * @author Jérôme Brilland
 * @version 1.0
 * @copyright (c) 2019, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class JSONFileConfigurationHandler extends ConfigurationHandler {
    
    /**
     * @var string filename
     * @access private
     */
    private $filename = null;     
    
    /**
     * Class constructor
     * @param string filename
     * @access public
     */
    public function __construct( $filename ) {
        if ( !is_readable( $filename ) ) {
            throw new Exception( $filename . ' cannot be read.' );
        }
        $this->filename = $filename;
    }

    /**
     * @access public
     */
    public function load() {
        $this->values = JSONHandler::decode( file_get_contents( $this->filename ), true );
        return $this;
    }
    
    /**
     * @access public
     */
    public function save() {
        if ( !is_writable( $this->filename ) ) {
            throw new Exception( 'File ' . $this->filename . ' is not writable.' );
        }
        file_put_contents( $this->filename, JSONHandler::encode( $this->values, JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT ) );
        return $this;
    }
    
}
?>
