<?php
/**
 * IView interface
 * @author Jérôme Brilland
 * @version 1.0
 * @copyright (c) 2018, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
interface IView {
    
    /**
     * @param string $name
     * @param mixed $value
     * @access public
     */
    public function assign( $name, $value );
    
    /**
     * @param string $directory
     * @access public
     */
    public function addTemplateDirectory( $directory );
    
    /**
     * Render a template
     * @param string $template Template
     * @param array $data
     * @return string Rendered template
     */
    public function render( $template, $data = null );    

}
?>
