<?php
/**
 * ISQLSchema interface
 * @author Jerôme Brilland
 * @version 1.0
 * @copyright (c) 2019, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
interface ISQLSchema {

    /**
     * @return array
     * @access public
     */
    public function getTables();

    /**
     * @param string $tableName
     * @return array
     * @access public
     */
    public function getColumns( $tableName );

    /**
     * @param string $tableName
     * @return array
     * @access public
     */
    public function getColumnNames( $tableName );

    /**
     * @param string $tableName
     * @param array $columns
     * @param mixed $parameters
     * @access public
     */
    function createTable( $tableName, $columns, $parameters = null );

    /**
     * @param string $tableName
     * @access public
     */
    function dropTable( $tableName );

    /**
     * @param string $tableName
     * @access public
     */
    function dropTableIfexists( $tableName );

    /**
     * @param string $tableName
     * @param string $columnName
     * @param mixed $options
     * @access public
     */
    function addColumn( $tableName, $columnName, $dataType, $options = [] );

    /**
     * @param string $tableName
     * @param string $columnName
     * @access public
     */
    function dropColumn( $tableName, $columnName );
    
    /**
     * @param string $identifier
     * @param string $tableName
     * @param mixed $columns
     * @access public
     */
    function addPrimaryKey( $identifier, $tableName, $columns );

    /**
     * @param string $identifier
     * @param string $tableName
     * @access public
     */
    function dropPrimaryKey( $identifier, $tableName );

    /**
     * @param string $identifier
     * @param string $tableName
     * @param string $columnName
     * @param string $referenceTableName
     * @param string $referenceColumnName
     * @param string $onDelete
     * @param string $onUpdate
     * @access public
     */
    function addForeignKey( $identifier, $tableName, $columnName, $referenceTableName, $referenceColumnName, $onDelete = null, $onUpdate = null );

    /**
     * @param string $identifier
     * @param string $tableName
     * @access public
     */
    function dropForeignKey( $identifier, $tableName );

    /**
     * @param string $identifier
     * @param string $tableName
     * @param mixed $columns
     * @param boolean $unique
     */
    function addIndex( $identifier, $tableName, $columns, $unique = false );

    /**
     * @param string $identifier
     * @param string $tableName
     */
    function dropIndex( $identifier, $tableName );

    /**
     * @param string $dataType
     * @return string The actual data type
     * @access public
     */
    function getDataType( $dataType );
}
