<?php
/**
 * Model interface
 * @author Jerôme Brilland
 * @version 2.0
 * @copyright (c) 2009, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
interface IModel {
	
	/**
	 * Saves model data
	 * @return boolean True if the data has been successfully saved, false otherwise.
	 * @access public
	 */
	public function save();
	
	/**
	 * Delete the model
	 * @return boolean True if the model has been successfully deleted, false otherwise.
	 * @access public
	 */
	public function delete();
	
	/**
	 * Retrieve any number of records from the database using a SELECT statement.
	 * @return array An array of records
	 * @access public
         * @static
	 */
	public static function findAll();
	
	/**
	 * Find selected records
	 * @return array An array of records
	 * @access public
         * @static
	 */
	public static function findMany();
	
	/**
	 * Returns the selected record
	 * @return IModel The selected record
	 * @access public
         * @static
	 */ 
	public static function findOne();
	
	/**
	 * Returns a String that represents the current Object.
	 * @return string A string representing the object
	 * @access public
	 */ 
	public function __toString();
	
}
?>
