<?php
/**
 * Database factory interface
 * @author Jérôme Brilland
 * @version 1.0
 * @since 3.0
 * @copyright (c) 2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
interface IDatabaseFactory {

    /**
     * Create a database connection
     * @return Medoo the database connection
     * @access public
     */
    public function createConnection();

    /**
     * Create a SQLSchema object
     * @param Medoo the database connection
     * @return ISQLSchema the SQLSchema object
     * @access public
     */
    public function createSQLSchema( $database );
}

