<?php
/**
 * file validator class
 * @author Jérôme Brilland
 * @version 1.0
 * @copyright Copyright &copy; 2015, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class FileValidator {
    
    /**
     * @return boolean
     * @access public
     * @static
     */
    public static function validateType( $filename, array $types ) {
        $finfo = finfo_open( FILEINFO_MIME_TYPE );
        if ( file_exists( $filename ) && !in_array( finfo_file( $finfo, $filename ), $types ) ) {
            $result = false;
        } else {
            $result = true;
        }
        finfo_close( $finfo );
        return $result;
    }
    
    /**
     * @return boolean
     * @access public
     * @static
     */
    public static function validateMinSize( $filename, $size ) {
        if ( file_exists( $filename ) && ( filesize( $filename ) < $size ) ) {
            return false;
        } else {
            return true;
        }
    }
    
    /**
     * @return boolean
     * @access public
     * @static
     */
    public static function validateMaxSize( $filename, $size ) {
        if ( file_exists( $filename ) && ( filesize( $filename ) > $size ) ) {
            return false;
        } else {
            return true;
        }
    }
    
    /**
     * @return boolean
     * @access public
     * @static
     */
    public static function validateImage( $filename ) {
        return self::validateType( $filename, array( 'image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/bmp' ) );
    }
    
    /**
     * @return boolean
     * @access public
     * @static
     */
    public static function validateAudio( $filename ) {
        return self::validateType( $filename, array( 'audio/mpeg', 'audio/mp4', 'audio/ogg', 'audio/webm', 'audio/wav' ) );
    }
    
    /**
     * @return boolean
     * @access public
     * @static
     */
    public static function validatePDF( $filename ) {
        return self::validateType( $filename, array( 'application/pdf' ) );
    } 
    
    /**
     * @return boolean
     * @access public
     * @static
     */
    public static function validateText( $filename ) {
        return self::validateType( $filename, array( 'text/css', 'text/csv', 'text/html', 'text/plain', 'text/xml' ) );
    } 
     
}
?>
