<?php
/**
 * Abstract controller class
 * @author Jérôme Brilland
 * @version 2.0
 * @copyright (c) 2009-2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 * @abstract
 */
abstract class Controller {
    
    /**
     * @var Request Request object
     * @access protected
     */
    protected $request;
    
    /**
     * @var Response Response object
     * @access protected
     */
    protected $response;

    /**
     * @return Request $request The request
     * @access public
     */
    public function getRequest() {
        return $this->request;
    }

    /**
     * @return Response $response The response
     * @access public
     */
    public function getResponse() {
        return $this->response;
    }
    
    /**
     * Forward the request to another action.
     * @param string $controllerName Controller name
     * @param string $actionName Action name
     * @throw StopException
     * @access public
     */
    public function forward( string $controllerName, string $actionName ) {
        if ( class_exists( $controllerName ) ) {
            $controller = new $controllerName( $this->request, $this->response );
            $controller->dispatchAction( $actionName );
            throw new StopException();
        } else {
            throw new UnknownControllerException();
        }
    }
}

