<?php
/**
 * ConfigurationHandler
 * @author Jérôme Brilland
 * @version 1.0
 * @copyright (c) 2019, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 * @abstract
 */
abstract class ConfigurationHandler implements IteratorAggregate, IConfigurationHandler {

    protected $values = [];

    /**
     * @param string key
     * @return boolean
     * @access public
     */
    public function has( $key ) {
        return array_key_exists( $key, $this->values );
    }

    /**
     * @param string key
     * @return mixed
     * @access public
     */
    public function get( $key, $default = null ) {
        if ( $this->has( $key ) ) {
            return $this->values[$key];
        } else {
            return $default;
        }
    }

    /**
     * @param string key
     * @param mixed value The value to store
     * @access public
     */
    public function set( $key, $value ) {
        $this->values[$key] = $value;
    }

    /**
     * @param string key
     * @access public
     */
    public function remove( $key ) {
        unset( $this->values[$key] );
    }

    /**
     * @return Traversable
     * @access public
     */
    public function getIterator() {
        return new ArrayIterator( $this->values );
    }
}
