<?php
/**
 * @author Jérôme Brilland
 * @version 2.0
 * @copyright (c) 2018-2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
if ( version_compare( PHP_VERSION, '7.3.0', '<' ) ) {
	die( 'Requires PHP 7.3.0 or higher.' );
}

function setReporting() {
    if ( DEVELOPMENT_ENVIRONMENT ) {
        error_reporting( E_ALL );
        ini_set( 'log_errors', '1' );
        ini_set( 'display_errors', '1' );
    } else {
        error_reporting( 0 );
        ini_set( 'log_errors', '1' );
        ini_set( 'display_errors', '0' );
    }
}

function dump( $value, $exit = false ) {
    echo '<pre>';
    print_r( $value );
    echo '</pre>';
    if ( $exit ) {
        exit();
    }
}

spl_autoload_register( function( $className ) {
        $filename = strtolower( str_replace( '\\', DS, $className ) ) . '.class.php';
        if ( stream_resolve_include_path( $filename ) ) {
            include( $filename );
        }
});

/* define the configuration files directory */
define( 'CONFIG_DIR', ROOT_DIR . 'config' . DS );

/* define the application directory */
define( 'APP_DIR', ROOT_DIR . 'application' . DS );

/* define the variable data directory */
define( 'VAR_DIR', ROOT_DIR . 'var' . DS );

/* define the controllers directory */
define( 'CONTROLLERS_DIR', 'controllers' . DS );

/* define the models directory */
define( 'MODELS_DIR', 'models' . DS );

/* define the templates directory */
define( 'TEMPLATES_DIR', 'templates' . DS );

define( 'PUBLIC_DIR', dirname( $_SERVER['SCRIPT_FILENAME'] ) . DS . 'public' . DS );

/* define the log directory */
define( 'LOG_DIR', ROOT_DIR . 'log' . DS );

include( CONFIG_DIR . 'dependencies.php' );

$config = IoC::resolve( 'config' );

define( 'DEVELOPMENT_ENVIRONMENT', $config['development_environment'] );

define( 'BASE_URL', $config['base_url'] );

setReporting();

/* include the registry class */
include( LIB_DIR . 'core' . DS . 'registry.class.php' );

/* include the request class */
include( LIB_DIR . 'core' . DS . 'request.class.php' );

/* include the response class */
include( LIB_DIR . 'core' . DS . 'response.class.php' );

/* include the controller class */
include( LIB_DIR . 'core' . DS . 'controller.class.php' );

/* include the front controller class */
include( LIB_DIR . 'core' . DS . 'frontcontroller.class.php' );

/* include the action controller class */
include( LIB_DIR . 'core' . DS . 'actioncontroller.class.php' );

/* include the filter chain class */
include( LIB_DIR . 'core' . DS . 'filterchain.class.php' );

/* include the abstract model class */
include( LIB_DIR . 'core' . DS . 'activerecord.class.php' );

/* include the pagination class */
include( LIB_DIR . 'core' . DS . 'paginator.class.php' );

/* include the validator class */
include( LIB_DIR . 'core' . DS . 'validator.class.php' );

/* include the CRUD controller class */
include( LIB_DIR . 'core' . DS . 'crudcontroller.class.php' );

/* include the Flash class */
include( LIB_DIR . 'core' . DS . 'flash.class.php' );

/* include the logger class */
include( LIB_DIR . 'core' . DS . 'logger.class.php' );

set_include_path( get_include_path() . PS . LIB_DIR . 'core' . DS . PS . LIB_DIR . '3rdparty' . DS . PS . APP_DIR );

require ROOT_DIR . 'vendor' . DS . 'autoload.php';

/* start session */
session_start();

/* generate a new session identifier */
session_regenerate_id();

date_default_timezone_set( $config['default_timezone'] );

$filterChain = IoC::resolve( 'filterchain' );
foreach( $config['filters'] as $className ) {
    $filterChain->addFilter( new $className() );
}
$filterChain->execute( IoC::resolve( 'request' ), IoC::resolve( 'response' ) );

