<?php
namespace install\services;

/**
 * Install service
 * @author Jérôme Brilland
 * @version 2.0
 * @copyright (c) 2019-2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class Install {

    private $settings;

    public function __construct( array $databaseSettings, array $settings ) {
        \IoC::register( 'config', function() use ( $databaseSettings ) {
            return ['database' => $databaseSettings];
        } );
        $this->settings = $settings;
    }

    public function perform( $listener ) {        
        $createDatabase = new CreateDatabase();
        $createDatabase->perform( $listener );

        $addSQLData = new AddSQLData( $this->settings );
        $addSQLData->perform( $listener );

        $writeConfigFile = new WriteConfigFile( \IoC::resolve( 'config' )['database'], $this->settings );
        $writeConfigFile->perform( $listener );
        
        $listener->installSucceeded();
    }

}
