<?php
namespace install\library;

/**
 * Implements the IFilter interface
 * @author Jerôme Brilland
 * @version 2.1
 * @copyright (c) 2019-2022, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class InstallFilter implements \IFilter {
    
    /**
	 * @param Request request Request object
	 * @param Response response Response object
	 * @access public
	 */
	public function execute( \Request $request, \Response $response, \FilterChain $filterchain ) {
        $requestUri = $request->getParameters()->getUrl( 'rt', '' );
        $request->setAttribute( 'controller', 'install\\controllers\\InstallController' );
        $action = ( !empty( $requestUri ) ) ? explode( '/', $requestUri )[1] : null;
        $request->setAttribute( 'action', ( empty( $action ) ) ? 'step1' : $action );
        $filterchain->execute( $request, $response );
    }
    
}

