<?php
IoC::register( 'config', function() {
    return new Configuration( new PHPFileConfigurationHandler( CONFIG_DIR . 'config.php' ) );
}, true );

IoC::register( 'database', function() {
    $options = IoC::resolve( 'config' )['database'];
    $type = $options['type'];
    switch( $type ) {
    case 'mysql':
        $factory = new MySQLFactory( $options );
        break;
    case 'pgsql':
        $factory = new PostgreSQLFactory( $options );
        break;
    case 'sqlite':
        $factory = new SQLiteFactory( $options );
        break;
    default:
        throw new LogicException( 'Unknow database' );
            
    }
    return $factory->createConnection();
}, true );

IoC::register( 'sqlschema', function() {
    $options = IoC::resolve( 'config' )['database'];
    $type = $options['type'];
    switch( $type ) {
    case 'mysql':
        $factory = new MySQLFactory( $options );
        break;
    case 'pgsql':
        $factory = new PostgreSQLFactory( $options );
        break;
    case 'sqlite':
        $factory = new SQLiteFactory( $options );
        break;
    default:
        throw new LogicException( 'Unknow database' );
            
    }
    return $factory->createSQLSchema( IoC::resolve( 'database' ) );
}, true );

IoC::register( 'latteDatabaseLoader', function() {
    return new LatteDatabaseLoader( IoC::resolve( 'database' ) );
}, true );

IoC::register( 'request', function() {
    return new Request();
}, true );

IoC::register( 'response', function() {
    return new Response();
}, true );

IoC::register( 'frontcontroller', function() {
    return new FrontController();
}, true );

IoC::register( 'filterchain', function() {
    return new FilterChain( IoC::resolve( 'frontcontroller') );
} );

IoC::register( 'eventmediator', function() {
    return new EventMediator();
}, true );

IoC::register( 'logger', function() {
    return new Logger( LOG_DIR . 'log.log' );
}, true );

// IoC::register( 'view', function() {
//     return new MustacheView();
// }, true );

IoC::register( 'view', function() {
    $view = new LatteView();
    $view->addFilter( 'translate', function( Latte\Runtime\FilterInfo $info, $value, ...$options ) {return IoC::resolve( 'i18n' )->__( $value, ...$options );} );
    return $view;
}, true );

IoC::register( 'locale', function() {
    if ( empty( $_SESSION['locale'] ) ) {
        $_SESSION['locale'] = IoC::resolve( 'config' )['default_locale'];
    }
    return $_SESSION['locale'];
} );

IoC::register( 'i18n', function() {
    $locale = IoC::resolve( 'locale' );
    $i18n = new I18n( $locale );
		
    $i18n->load( ROOT_DIR . 'i18n' . DS . $locale . '.ini' );
    return $i18n;
}, true );

IoC::register( 'texy', function() {
    $texy = new Texy();
	    
    //headings
    // $texy->headingModule->top = 1;
    // $texy->headingModule->balancing = TexyHeadingModule::FIXED;

    $texy->allowed['phrase/ins'] = true;
    $texy->allowed['phrase/del'] = true;
    $texy->allowed['phrase/sup'] = true;
    $texy->allowed['phrase/sub'] = true;
    $texy->allowed['phrase/cite'] = true;
	    
    //images
    $texy->imageModule->root = BASE_URL . '/public/images';
	    
    //emoticons
    $texy->allowed['emoticon'] = TRUE;
    return $texy;
}, true );

IoC::register( 'databaseConfigurationHandler', function() {
    return new \DatabaseConfigurationHandler( 'setting', 'name', 'value', IoC::resolve( 'database' ) );
} );

IoC::register( 'settings', function() {
    return new \Configuration( IoC::resolve( 'databaseConfigurationHandler' ) );
}, true );

IoC::register( 'user', function() {
    if ( !empty( $_SESSION['user_id'] ) ) {
        return models\User::findOne( $_SESSION['user_id'] );
    } else {
        return new models\GuestUser();
    }
}, true );

IoC::register( 'authorization', function() {
    return new library\Authorization( IoC::resolve( 'user' ) );
}, true );
