<?php
namespace services\authorization;

use \models\User;

/**
 * Password reset service
 * @author Jérôme Brilland
 * @version 2.0
 * @copyright (c) 2019-2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class ResetPassword {

    private $email;
    private $token;
    private $password;
    private $passwordConfirmation;

    public function __construct( $email, $token, $password, $passwordConfirmation ) {
        $this->email = $email;
        $this->token = $token;
        $this->password = $password;
        $this->passwordConfirmation = $passwordConfirmation;
    }

    public function perform( $listener ) {
        \IoC::resolve( 'eventmediator' )->trigger( 'before_reset_password' );        
        $user = User::findOne( ['email' => $this->email, 'password_reset_token' => $this->token ] );
        if ( empty( $user ) || $this->passwordResetExpired( $user ) ) {
            \IoC::resolve( 'eventmediator' )->trigger( 'invalid_password_reset_token' );
            $listener->validateTokenFailed();
        } else {
            $user->password = $this->password;
            $user->password_confirmation = $this->passwordConfirmation;
            $user->password_reset_token = null;
            $user->password_reset_sent_at = null;
     
            if ( !$user->save() ) {
                $listener->resetPasswordFailed( $user );
            } else {
                \IoC::resolve( 'eventmediator' )->trigger( 'after_reset_password' );
                $listener->resetPasswordSucceeded();
            }
        }
    }

    private function passwordResetExpired( $user ) {
        $now = new \DateTime();
        $time = \DateTime::createFromFormat( 'Y-m-d H:i:s', $user->password_reset_sent_at );
        return( $time->modify( '+2 hour' ) < $now );
    }

}
