<?php
namespace services\authorization;

/**
 * @author Jérôme Brilland
 * @version 2.0
 */
class RemoveRoleFromUser {

    private $userId;
    private $roleId;

    public function __construct( $userId, $roleId ) {
        $this->userId = $userId;
        $this->roleId = $roleId;
    }
    
    public function perform( $listener ) {
        $userRole = \models\UserRole::findOne( ['user_id' => $this->userId, 'role_id' => $this->roleId] );
        if ( $userRole ) {
            $userRole->delete();
            $listener->removeRoleSucceeded();
        } else {
            $listener->removeRoleFailed();
        }
    }
    
}
