<?php
namespace services\authorization;

/**
 * @author Jérôme Brilland
 * @version 2.0
 */
class RemovePermissionFromRole {

    private $permissionId;
    private $roleId;

    public function __construct( $permissionId, $roleId ) {
        $this->permissionId = $permissionId;
        $this->roleId = $roleId;
    }
    
    public function perform( $listener ) {
        $permissionRole = \models\RolePermission::findOne( ['permission_id' => $this->permissionId, 'role_id' => $this->roleId] );
        $permissionRole->delete();
        $listener->removePermissionSucceeded();
    }
}
