<?php
namespace services\authorization;

/**
 * Use case service
 * @author Jérôme Brilland
 * @version 2.0
 */
class AddRoleToUser {

    private $userId;
    private $roleId;

    public function __construct( $userId, $roleId ) {
        $this->userId = $userId;
        $this->roleId = $roleId;
    }
    
    public function perform( $listener ) {
        $userRole = new \models\UserRole( ['user_id' => $this->userId, 'role_id' => $this->roleId] );
        if ( $userRole->save() ) {
            $listener->addRoleSucceeded();
        } else {
            $listener->addRoleFailed( $userRole->getErrors() );
        }
    }
}
