<?php
namespace services\authorization;

/**
 * @author Jérôme Brilland
 * @version 2.0
 */
class AddPermissionToRole {

    private $permissionId;
    private $roleId;

    public function __construct( $permissionId, $roleId ) {
        $this->permissionId = $permissionId;
        $this->roleId = $roleId;
    }
    
    public function perform( $listener ) {
        $permissionRole = new \models\RolePermission( ['permission_id' => $this->permissionId, 'role_id' => $this->roleId] );
        if ( $permissionRole->save() ) {
            $listener->addPermissionSucceeded();
        } else {
            $listener->addPermissionFailed( $permissionRole->getErrors() );
        }
    }
}
