<?php
namespace models;

/**
 * Permission model class
 * @author Jérôme Brilland
 * @version 2.0
 */
class Permission extends \ActiveRecord {

    public function validate() {
        $i18n = \IoC::resolve( 'i18n' );
        $this->validateMaxLength( 'name', 100, $i18n->__( 'too_long_name', 100 ) );
        $this->validateNotEmpty( 'name', $i18n->__( 'name_cannot_be_empty' ) );
        $this->validateUnique( 'name', $i18n->__( 'name_taken' ) );
    }

    protected function beforeSave() {
        $this->name = trim( $this->name );
        if ( !empty( $this->description ) ) {
            $this->description = ucfirst( $this->description );
        }
    }
    
    public static function findByName( $name ) {
        return self::findOne( ['name' => $name] );
    }

    public function __toString() {
        return $this->name;
    }

}
