<?php
namespace models;

/**
 * GuestUser class
 * Implements the IUser interface
 * @version 2.0
 */
class GuestUser implements IUser {

    /**
     * @return boolean
     */
    public function isAuthenticated() {
        return false;
    }

    /**
     * @return string
     */
    public function getName() {
        return 'guest';
    }

    /**
     * @return array
     */
    public function getPermissions() {
        return [];
    }

    public function hasPermission( $name ) {
        return false;
    }
    
}
