<?php
namespace library;
/**
 * Implements the IFilter interface
 * @author Jerôme Brilland
 * @version 2.0
 * @copyright (c) 2019-2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class PluginsFilter implements \IFilter {

    /**
	 * @param Request request Request object
	 * @param Response response Response object
	 * @access public
	 */
	public function execute( \Request $request, \Response $response, \FilterChain $filterchain ) {
		$settings = \IoC::resolve( 'settings' );
        foreach ( unserialize( $settings['plugins'] ) as $pluginName => $isActivated ) {
            if ( $isActivated ) {
                $pluginName = explode( '[', $pluginName )[0];
                $filename = APP_DIR . 'plugins' . DS . $pluginName . DS . 'initialize.php';
                if ( !is_readable( $filename ) ) {
                    die( sprintf( 'File "%s" could not be found or is not readable.', $filename ) );
                }
                include( $filename );

                $locale = \IoC::resolve( 'locale' );
                $filename = APP_DIR . 'plugins' . DS . $pluginName . DS . 'i18n' . DS . $locale . '.ini';
                if ( is_readable( $filename ) ) {
                    $i18n = \IoC::resolve( 'i18n' );
                    $i18n->load( $filename );
                }
            }
        }
		$filterchain->execute( $request, $response );
	}
}
