<?php
namespace library;
/**
 * Backend menu class
 * @author Jérôme Brilland
 * @version 2.0
 * @copyright (c) 2019-2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class BackendMenu extends \SplDoublyLinkedList {

    /**
     * @access public
     */
    public function __construct() {
        $authorization = \IoC::resolve( 'authorization' );

        $submenu = [];
        if ( $authorization->isAuthorized( 'view_pages' ) ) {
            $submenu[] = ['name' => 'pages', 'url' => BASE_URL . 'page/list'];
        }
        if ( $authorization->isAuthorized( 'view_snippets' ) ) {
            $submenu[] = ['name' => 'snippets', 'url' => BASE_URL . 'snippet/list'];
        }
        if ( $authorization->isAuthorized( 'view_templates' ) ) {
            $submenu[] = ['name' => 'templates', 'url' => BASE_URL . 'template/list'];
        }
        if ( !empty( $submenu ) ) {
            $this->push( ['name' => 'content', 'url' => '#', 'submenu' => $submenu ] );
        }
        
        if ( $authorization->isAuthorized( 'view_users' ) ) {
            $this->push( ['name' => 'users', 'url' => BASE_URL . 'user/list'] );
        }
        if ( $authorization->isAuthorized( 'manage_settings' ) ) {
            $this->push( ['name' => 'settings', 'url' => BASE_URL . 'system/settings'] );
        }
        if ( $authorization->isAuthorized( 'manage_plugins' ) ) {
            $this->push( ['name' => 'plugins', 'url' => BASE_URL . 'system/plugins'] );
        }
        \IoC::resolve( 'eventmediator' )->trigger( 'after_initialize_backend_menu', [$this] );
        $this->push( ['name' => 'view_site', 'url' => BASE_URL] );
        $this->push( ['name' => 'log_out', 'url' => BASE_URL . 'logout'] );
    }
}
