<?php
namespace controllers;

use models\Template;

/**
 * Template controller
 * @author Jérôme Brilland
 * @version 2.0
 * @copyright (c) 2018-2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class TemplateController extends \CRUDController {

    protected $modelClassName = 'models\\Template';

    public function doList() {
        $this->columns = [
            'template_id',
            'name',
            'created_at',
            'updated_at'
        ];
        parent::doList();
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'view_templates' );
        $i18n = \IoC::resolve( 'i18n' );
        $this->title = $i18n->__( 'templates' );
        $this->templates = $this->models;
    }

    public function doAddform() {
        parent::doAddform();
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'create_template' );
        $i18n = \IoC::resolve( 'i18n' );
        $this->title = $i18n->__( 'add_template' );
    }

    public function doAdd() {
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'create_template' );
        parent::doAdd();
    }

    public function doUpdateform() {
        parent::doUpdateform();
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'update_template' );
        $i18n = \IoC::resolve( 'i18n' );
        $this->title = $i18n->__( 'update_template' );
    }

    public function doUpdate() {
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'update_template' );
        parent::doUpdate();
    }

    protected function afterAdd() {
        if ( $this->request->getParameters()->getBoolean( 'continue', false ) ) {
            $this->redirect( BASE_URL . 'template/update/' . $this->model->template_id );
        } else {
            $this->redirect( BASE_URL . 'template/list' );
        }
    }

    protected function afterUpdate() {
        if ( $this->request->getParameters()->getBoolean( 'continue', false ) ) {
            $this->redirect( BASE_URL . 'template/update/' . $this->model->template_id );
        } else {
            $this->redirect( BASE_URL . 'template/list' );
        }
    }

    public function doDeleteForm() {
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'delete_template' );
        parent::doDeleteForm();
    }

    public function doDelete() {
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'delete_template' );
        $template = Template::findOne( ['template_id', 'name'], ['template_id' => $this->request->getAttribute( 'id' )] );
        if ( $template->isUsed() ) {
            $this->flash['error'] = \IoC::resolve( 'i18n' )->__( 'template_in_use', $template->name );
            $this->redirect( BASE_URL . 'template/list' );
        }
        parent::doDelete();
    }
}
