<?php
namespace controllers;

use models\Snippet;

/**
 * Snippet controller
 * @author Jérôme Brilland
 * @version 2.1
 * @copyright (c) 2018-2022, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class SnippetController extends \CRUDController {

    protected $modelClassName = 'models\Snippet';

    public function doList() {
        if ( 0 == Snippet::count() ) {
            $this->redirect( BASE_URL . 'snippet/add' );
        }
        parent::doList();
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'view_snippets' );
        $i18n = \IoC::resolve( 'i18n' );
        $this->title = $i18n->__( 'snippets' );
        $this->snippets = $this->models;
    }

    public function doAddform() {
        parent::doAddform();
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'create_snippet' );
        $i18n = \IoC::resolve( 'i18n' );
        $this->title = $i18n->__( 'add_snippet' );
    }

    public function doAdd() {
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'create_snippet' );
        parent::doAdd();
    }

    public function doUpdateform() {
        parent::doUpdateform();
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'update_snippet' );
        $i18n = \IoC::resolve( 'i18n' );
        $this->title = $i18n->__( 'update_snippet' );
    }

    public function doUpdate() {
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'update_snippet' );
        parent::doUpdate();
    }

    public function doMoveUp() {
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'update_snippet' );
        $this->doList();
    }

    public function doMoveDown() {
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'update_snippet' );
        $this->doList();
    }

    protected function afterAdd() {
        if ( $this->request->getParameters()->getBoolean( 'continue', false ) ) {
            $this->redirect( BASE_URL . 'snippet/update/' . $this->model->snippet_id );
        } else {
            $this->redirect( BASE_URL . 'snippet/list' );
        }
    }

    protected function afterUpdate() {
        if ( $this->request->getParameters()->getBoolean( 'continue', false ) ) {
            $this->redirect( BASE_URL . 'snippet/update/' . $this->model->snippet_id );
        } else {
            $this->redirect( BASE_URL . 'snippet/list' );
        }
    }

    public function doDeleteForm() {
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'delete_snippet' );
        parent::doDeleteForm();
    }

    public function doDelete() {
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'delete_snippet' );
        parent::doDelete();
    }
  
}
