<?php
namespace controllers;

use \models\Plugin;
use \services\plugin\InstallPlugin;
use \services\plugin\UninstallPlugin;
use \services\plugin\ActivatePlugin;
use \services\plugin\DeactivatePlugin;
use \services\plugin\UpgradePlugin;

/**
 * Plugin controller
 * @author Jérôme Brilland
 * @version 3.1
 * @copyright (c) 2019-2022, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class PluginController extends \ActionController {

    protected function beforeFilter() {
        $authorization = \IoC::resolve( 'authorization' );
        $authorization->authorize( 'manage_plugins' );
    }

    public function doIndex() {
        $this->plugins = Plugin::findAll();
        $i18n = \IoC::resolve( 'i18n' );
        $this->title = $i18n->__( 'plugin_manager' );
    }

    public function doInstall() {
        $pluginName = $this->request->getParameters()->getString( 'name', null, 'full_special_chars' );
        $install = new InstallPlugin( $pluginName );
        $install->perform( $this );
    }

    public function installPluginSucceeded( $pluginName ) {
        $this->flash['success'] = \IoC::resolve( 'i18n' )->__( 'plugin_successfully_installed' );
        $this->redirect( BASE_URL . 'system/plugins' );
    }

    public function installPluginFailed( $pluginName ) {
        $this->flash['error'] = $this->flash['error'] ?: \IoC::resolve( 'i18n' )->__( 'plugin_install_error' );
        $this->redirect( BASE_URL . 'system/plugins' );
    }

    public function doUninstall() {
        $pluginName = $this->request->getParameters()->getString( 'name', null, 'full_special_chars' );
        $uninstall = new UninstallPlugin( $pluginName );
        $uninstall->perform( $this );
    }

    public function uninstallPluginSucceeded( $pluginName ) {
        $this->flash['success'] = \IoC::resolve( 'i18n' )->__( 'plugin_successfully_uninstalled' );
        $this->redirect( BASE_URL . 'system/plugins' );
    }

    public function uninstallPluginFailed( $pluginName ) {
        $this->flash['error'] = $this->flash['error'] ?: \IoC::resolve( 'i18n' )->__( 'plugin_uninstall_error' );
        $this->redirect( BASE_URL . 'system/plugins' );
    }

    public function doActivate() {
        $pluginName = $this->request->getParameters()->getString( 'name', null, 'full_special_chars' );
        $activate = new ActivatePlugin( $pluginName );
        $activate->perform( $this );
    }

    public function activatePluginSucceeded( $pluginName ) {
        $this->flash['success'] = \IoC::resolve( 'i18n' )->__( 'plugin_successfully_activated' );
        $this->redirect( BASE_URL . 'system/plugins' );
    }

    public function activatePluginFailed( $pluginName ) {
        $this->flash['error'] = $this->flash['error'] ?: \IoC::resolve( 'i18n' )->__( 'plugin_activation_error' );
        $this->redirect( BASE_URL . 'system/plugins' );
    }

    public function doDeactivate() {
        $pluginName = $this->request->getParameters()->getString( 'name', null, 'full_special_chars' );
        $activate = new DeactivatePlugin( $pluginName );
        $activate->perform( $this );
    }

    public function deactivatePluginSucceeded( $pluginName ) {
        $this->flash['success'] = \IoC::resolve( 'i18n' )->__( 'plugin_successfully_deactivated' );
        $this->redirect( BASE_URL . 'system/plugins' );
    }

    public function deactivatePluginFailed( $pluginName ) {
        $this->flash['error'] = $this->flash['error'] ?: \IoC::resolve( 'i18n' )->__( 'plugin_deactivation_error' );
        $this->redirect( BASE_URL . 'system/plugins' );
    }

    public function doUpgrade() {
        $pluginName = $this->request->getParameters()->getString( 'name', null, 'full_special_chars' );
        $activate = new UpgradePlugin( $pluginName );
        $activate->perform( $this );
    }

    public function upgradePluginSucceeded( $pluginName ) {
        $this->flash['success'] = \IoC::resolve( 'i18n' )->__( 'plugin_successfully_upgraded' );
        $this->redirect( BASE_URL . 'system/plugins' );
    }

    public function upgradePluginFailed( $pluginName ) {
        $this->flash['error'] = $this->flash['error'] ?: \IoC::resolve( 'i18n' )->__( 'plugin_upgrade_error' );
        $this->redirect( BASE_URL . 'system/plugins' );
    }
}
