<?php
namespace controllers;

/**
 * Home controller
 * @author Jérôme Brilland
 * @version 3.0
 * @copyright (c) 2019-2021, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class HomeController extends \ActionController {

    /**
     * @access public
     */
    public function doIndex() {
        \IoC::resolve( 'eventmediator' )->trigger( 'home_index_action', [$this] );
        $homePage = \IoC::resolve( 'settings' )['home_page'];
        $controllerName = 'controllers\\PageController';
        $actionName = 'show';
        $this->request->setAttribute( 'id', $homePage );
        $this->forward( $controllerName, $actionName );
    }
}
